/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import io.spring.javaformat.config.JavaFormatConfig;
import io.spring.javaformat.formatter.Formatter;
import io.spring.javaformat.formatter.StreamsEdit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.eclipse.text.edits.TextEdit;

public class StreamsFormatter {
    private final Formatter formatter;

    public StreamsFormatter() {
        this(new Formatter());
    }

    public StreamsFormatter(JavaFormatConfig javaFormatConfig) {
        this(new Formatter(javaFormatConfig));
    }

    public StreamsFormatter(Formatter formatter) {
        Optional.ofNullable(formatter).orElseThrow(() -> new IllegalArgumentException("Formatter must not be null"));
        this.formatter = formatter;
    }

    public StreamsEdit format(InputStream inputStream) {
        return this.format(inputStream, StandardCharsets.UTF_8);
    }

    public StreamsEdit format(InputStream inputStream, Charset encoding) {
        return this.format(inputStream, encoding, Formatter.DEFAULT_LINE_SEPARATOR);
    }

    public StreamsEdit format(InputStream inputStream, Charset encoding, String lineSeparator) {
        return this.format(new InputStreamReader(inputStream, encoding), lineSeparator);
    }

    public StreamsEdit format(Reader reader) {
        return this.format(reader, Formatter.DEFAULT_LINE_SEPARATOR);
    }

    public StreamsEdit format(Reader reader, String lineSeparator) {
        try {
            String content = this.readContent(reader);
            TextEdit edit = this.formatter.format(content, lineSeparator);
            return new StreamsEdit(content, edit);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String readContent(Reader reader) throws IOException {
        int numChars;
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[2048];
        while ((numChars = reader.read(buffer)) >= 0) {
            result.append(buffer, 0, numChars);
        }
        return result.toString();
    }
}

