/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.api.FileText;
import io.spring.nohttp.HttpMatchResult;
import io.spring.nohttp.HttpMatcher;
import io.spring.nohttp.RegexHttpMatcher;
import io.spring.nohttp.RegexPredicate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoHttpCheck
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private HttpMatcher matcher;
    private String whitelistFileName = "";
    private String whitelist = "";

    public void setWhitelistFileName(String whitelistFileName) {
        if (whitelistFileName == null) {
            throw new IllegalArgumentException("whitelistFileName cannot be null");
        }
        this.whitelistFileName = whitelistFileName;
    }

    public void setWhitelist(String whitelist) {
        if (whitelist == null) {
            throw new IllegalArgumentException("whitelist cannot be null");
        }
        this.whitelist = whitelist;
    }

    private boolean isWhitelistFileSet() {
        return !this.whitelistFileName.isEmpty();
    }

    private boolean isWhitelistSet() {
        return !this.whitelist.isEmpty();
    }

    private InputStream createWhitelistInputStream() {
        File whitelistFile = new File(this.whitelistFileName);
        try {
            return new FileInputStream(whitelistFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Could not load file '" + whitelistFile + "'", e);
        }
    }

    protected void finishLocalSetup() throws CheckstyleException {
        InputStream inputStream;
        RegexHttpMatcher matcher = new RegexHttpMatcher(RegexPredicate.createDefaultUrlWhitelist());
        if (this.isWhitelistFileSet()) {
            inputStream = this.createWhitelistInputStream();
            matcher.addHttpWhitelist(RegexPredicate.createWhitelistFromPatterns((InputStream)inputStream));
        }
        if (this.isWhitelistSet()) {
            inputStream = new ByteArrayInputStream(this.whitelist.getBytes());
            matcher.addHttpWhitelist(RegexPredicate.createWhitelistFromPatterns((InputStream)inputStream));
        }
        this.matcher = matcher;
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        int lineNum = 0;
        for (int index = 0; index < fileText.size(); ++index) {
            String line = fileText.get(index);
            ++lineNum;
            List results = this.matcher.findHttp(line);
            for (HttpMatchResult result : results) {
                this.log(lineNum, result.getStart() + 1, "nohttp", new Object[]{result.getHttp()});
            }
        }
    }

    public Set<String> getExternalResourceLocations() {
        HashSet<String> result = new HashSet<String>();
        if (this.isWhitelistFileSet()) {
            result.add(this.whitelistFileName);
        }
        return result;
    }
}

