/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.crdgenerator;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.api.annotations.ApiVersion;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.annotations.DeprecatedType;
import io.strimzi.crdgenerator.Linker;
import io.strimzi.crdgenerator.Property;
import io.strimzi.crdgenerator.PropertyType;
import io.strimzi.crdgenerator.Schema;
import io.strimzi.crdgenerator.annotations.AddedIn;
import io.strimzi.crdgenerator.annotations.Crd;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class DocGenerator {
    private static final String NL = System.lineSeparator();
    private static final Pattern DOT_AT_THE_END = Pattern.compile(".*[.!?]$", 32);
    private final int headerDepth;
    private final Appendable out;
    private final ApiVersion crApiVersion;
    private final Set<Class<?>> documentedTypes = new HashSet();
    private final HashMap<Class<?>, Set<Class<?>>> usedIn;
    private final Linker linker;
    private int numErrors = 0;

    public DocGenerator(ApiVersion crApiVersion, int headerDepth, Iterable<Class<? extends CustomResource>> crdClasses, Appendable out, Linker linker) {
        this.crApiVersion = crApiVersion;
        this.out = out;
        this.headerDepth = headerDepth;
        this.linker = linker;
        this.usedIn = new HashMap();
        for (Class<? extends CustomResource> crdClass : crdClasses) {
            this.usedIn(crdClass, this.usedIn);
        }
    }

    private void appendAnchor(Class<?> anchor) throws IOException {
        this.out.append("[id='").append(this.anchor(anchor)).append("']").append(NL);
    }

    private String anchor(Class<?> anchor) {
        return "type-" + anchor.getSimpleName() + "-{context}";
    }

    private void appendHeading(String name) throws IOException {
        this.appendRepeated('=', this.headerDepth);
        this.out.append(' ');
        this.out.append(name);
        this.out.append(" schema reference");
        this.out.append(NL);
        this.out.append(NL);
    }

    private void usedIn(Class<?> cls, Map<Class<?>, Set<Class<?>>> usedIn) {
        HashSet<Property> memorableProperties = new HashSet<Property>();
        for (Property property : Property.properties(this.crApiVersion, cls).values()) {
            if (property.isAnnotationPresent(KubeLink.class)) continue;
            memorableProperties.add(property);
        }
        for (Property property : memorableProperties) {
            PropertyType propertyType = property.getType();
            Class<?> type = propertyType.isArray() ? propertyType.arrayBase() : propertyType.getType();
            for (Class<?> c : this.subtypesOrSelf(type)) {
                if (Schema.isJsonScalarType(c)) continue;
                Set<Class<?>> classes = this.getOrCreateClassesSet(c, usedIn);
                classes.add(cls);
                this.usedIn(c, usedIn);
            }
        }
    }

    private Set<Class<?>> getOrCreateClassesSet(Class<?> c, Map<Class<?>, Set<Class<?>>> usedIn) {
        return usedIn.computeIfAbsent(c, cls -> new HashSet(1));
    }

    private List<? extends Class<?>> subtypesOrSelf(Class<?> returnType) {
        return Property.isPolymorphic(returnType) ? Property.subtypes(returnType) : Collections.singletonList(returnType);
    }

    public void generate(Class<? extends CustomResource> crdClass) throws IOException {
        Crd crd = crdClass.getAnnotation(Crd.class);
        this.appendAnchor(crdClass);
        this.appendHeading("`" + crd.spec().names().kind() + "`");
        this.appendCommonTypeDoc(crd, crdClass);
    }

    private void appendedNestedTypeDoc(Crd crd, Class<?> cls) throws IOException {
        this.appendAnchor(cls);
        this.appendHeading("`" + cls.getSimpleName() + "`");
        this.appendCommonTypeDoc(crd, cls);
    }

    private void appendCommonTypeDoc(Crd crd, Class<?> cls) throws IOException {
        this.appendTypeDeprecation(crd, cls);
        this.appendUsedIn(crd, cls);
        this.appendDescription(cls);
        this.appendDiscriminator(crd, cls);
        this.out.append("[cols=\"2,2,3a\",options=\"header\"]").append(NL);
        this.out.append("|====").append(NL);
        this.out.append("|Property |Property type |Description").append(NL);
        LinkedHashSet types = new LinkedHashSet();
        for (Map.Entry<String, Property> entry : Property.properties(this.crApiVersion, cls).entrySet()) {
            Class<?> documentedType;
            String propertyName = entry.getKey();
            Property property = entry.getValue();
            PropertyType propertyType = property.getType();
            KubeLink kubeLink = property.getAnnotation(KubeLink.class);
            String externalUrl = this.linker != null && kubeLink != null ? this.linker.link(kubeLink) : null;
            this.out.append("|").append(propertyName);
            this.appendPropertyType(crd, this.out, propertyType, externalUrl);
            this.addDeprecationWarning(property);
            this.addAddedIn(property);
            Class<?> clazz = documentedType = propertyType.isArray() ? propertyType.arrayBase() : propertyType.getType();
            if (!(externalUrl != null || Schema.isJsonScalarType(documentedType) || documentedType.equals(Map.class) || documentedType.equals(Object.class))) {
                types.add(documentedType);
            }
            this.addDescription(cls, property);
            this.out.append(NL);
        }
        this.out.append("|====").append(NL).append(NL);
        this.appendNestedTypes(crd, types);
    }

    private void addDeprecationWarning(Property property) throws IOException {
        DeprecatedProperty strimziDeprecated = property.getAnnotation(DeprecatedProperty.class);
        Deprecated langDeprecated = property.getAnnotation(Deprecated.class);
        if (strimziDeprecated != null || langDeprecated != null) {
            if (strimziDeprecated == null || langDeprecated == null) {
                this.err(property + " must be annotated with both @" + Deprecated.class.getName() + " and @" + DeprecatedProperty.class.getName());
            }
            if (strimziDeprecated != null) {
                this.out.append(this.getDeprecation(property, strimziDeprecated));
            }
        }
    }

    private void addDescription(Class<?> cls, Property property) throws IOException {
        Description description = property.getAnnotation(Description.class);
        if (description == null) {
            if (cls.getName().startsWith("io.strimzi")) {
                this.err(property + " is not documented");
            }
        } else {
            this.out.append(DocGenerator.getDescription(description));
        }
    }

    private void addAddedIn(Property property) throws IOException {
        AddedIn addedIn = property.getAnnotation(AddedIn.class);
        if (addedIn != null) {
            this.out.append("Added in Strimzi " + addedIn.value() + ". ");
        }
    }

    private void addExternalUrl(Property property, KubeLink kubeLink, String externalUrl) throws IOException {
        if (externalUrl != null) {
            this.out.append(" For more information, see the ").append(externalUrl).append("[").append("external documentation for ").append(kubeLink.group()).append("/").append(kubeLink.version()).append(" ").append(kubeLink.kind()).append("].").append(NL).append(NL);
        } else if (Property.isPolymorphic(property.getType().getType())) {
            this.out.append(" The type depends on the value of the `").append(property.getName()).append(".").append(Property.discriminator(property.getType().getType())).append("` property within the given object, which must be one of ").append(Property.subtypeNames(property.getType().getType()).toString()).append(".");
        }
    }

    private String getDeprecation(Property property, DeprecatedProperty deprecated) {
        Object msg = String.format("**The `%s` property has been deprecated", property.getName());
        if (!deprecated.movedToPath().isEmpty()) {
            msg = (String)msg + ", and should now be configured using `" + deprecated.movedToPath() + "`";
        }
        if (!deprecated.removalVersion().isEmpty()) {
            msg = (String)msg + ". The property " + property.getName() + " is removed in API version `" + deprecated.removalVersion() + "`";
        }
        msg = (String)msg + ".** ";
        if (!deprecated.description().isEmpty()) {
            msg = (String)msg + deprecated.description() + " ";
        }
        return msg;
    }

    static String getDescription(Description description) {
        Object doc = description.value();
        if (!DOT_AT_THE_END.matcher(((String)doc).trim()).matches()) {
            doc = (String)doc + ".";
        }
        doc = ((String)doc).replaceAll("[|]", "\\\\|");
        return doc;
    }

    private void err(String s) {
        System.err.println(DocGenerator.class.getSimpleName() + ": error: " + s);
        ++this.numErrors;
    }

    private void appendNestedTypes(Crd crd, LinkedHashSet<Class<?>> types) throws IOException {
        for (Class clazz : types) {
            for (Class<?> t2 : this.subtypesOrSelf(clazz)) {
                if (this.documentedTypes.contains(t2)) continue;
                this.appendedNestedTypeDoc(crd, t2);
                this.documentedTypes.add(t2);
            }
        }
    }

    private void appendPropertyType(Crd crd, Appendable out, PropertyType propertyType, String externalUrl) throws IOException {
        HashSet<String> strings;
        Class<?> propertyClass = propertyType.isArray() ? propertyType.arrayBase() : propertyType.getType();
        out.append(NL);
        out.append("|");
        if (externalUrl != null) {
            out.append(externalUrl).append("[").append(propertyClass.getSimpleName()).append("]");
        } else if (propertyType.isEnum()) {
            strings = new HashSet<String>();
            for (JsonNode n : Schema.enumCases(propertyType.getEnumElements())) {
                if (n.isTextual()) {
                    strings.add(n.asText());
                    continue;
                }
                throw new RuntimeException("Enum case is not a string");
            }
            out.append("string (one of " + strings + ")");
        } else if (propertyType.isArray() && propertyType.arrayBase().isEnum()) {
            try {
                strings = new HashSet();
                Method valuesMethod = propertyType.arrayBase().getMethod("values", new Class[0]);
                for (JsonNode n : Schema.enumCases((Enum[])valuesMethod.invoke(null, new Object[0]))) {
                    if (n.isTextual()) {
                        strings.add(n.asText());
                        continue;
                    }
                    throw new RuntimeException("Enum case is not a string");
                }
                out.append("string (one or more of " + strings + ")");
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.typeLink(crd, out, propertyClass);
        }
        if (propertyType.isArray()) {
            out.append(" array");
            int dim = propertyType.arrayDimension();
            if (dim > 1) {
                out.append(" of dimension ").append(String.valueOf(dim));
            }
        }
        out.append(NL);
        out.append("|");
    }

    private void appendTypeDeprecation(Crd crd, Class<?> cls) throws IOException {
        DeprecatedType deprecatedType = cls.getAnnotation(DeprecatedType.class);
        Deprecated langDeprecated = cls.getAnnotation(Deprecated.class);
        if (deprecatedType != null || langDeprecated != null) {
            if (deprecatedType == null || langDeprecated == null) {
                this.err(cls.getName() + " must be annotated with both @" + Deprecated.class.getName() + " and @" + DeprecatedType.class.getName());
            }
            if (deprecatedType != null && deprecatedType.replacedWithType() != null) {
                Class<?> replacementClss = deprecatedType.replacedWithType();
                this.out.append("*The type `" + cls.getSimpleName() + "` has been deprecated");
                if (!deprecatedType.removalVersion().isEmpty()) {
                    this.out.append(" and is removed in API version `" + deprecatedType.removalVersion() + "`");
                }
                this.out.append(".*").append(NL);
                if (replacementClss != Void.TYPE) {
                    this.out.append("Please use ");
                    this.typeLink(crd, this.out, replacementClss);
                    this.out.append(" instead.").append(NL);
                }
                this.out.append(NL);
            }
        }
    }

    private void appendDescription(Class<?> cls) throws IOException {
        DescriptionFile descriptionFile = cls.getAnnotation(DescriptionFile.class);
        Description description = cls.getAnnotation(Description.class);
        if (descriptionFile != null) {
            String filename = "api/" + cls.getCanonicalName() + ".adoc";
            File includeFile = new File(filename);
            if (!includeFile.isFile()) {
                throw new RuntimeException("Class " + cls.getCanonicalName() + " has @DescribeFile annotation, but file " + filename + " does not exist!");
            }
            this.out.append("xref:type-").append(cls.getSimpleName()).append("-schema-{context}[Full list of `").append(cls.getSimpleName()).append("` schema properties]").append(NL);
            this.out.append(NL);
            this.out.append("include::../" + filename + "[leveloffset=+1]").append(NL);
            this.out.append(NL);
            this.out.append("[id='type-").append(cls.getSimpleName()).append("-schema-{context}']").append(NL);
            this.out.append("== `").append(cls.getSimpleName()).append("` schema properties").append(NL);
            this.out.append(NL);
        } else if (description != null) {
            this.out.append(DocGenerator.getDescription(description)).append(NL);
        }
        this.out.append(NL);
    }

    private void appendUsedIn(Crd crd, Class<?> cls) throws IOException {
        ArrayList<Class> usedIn = new ArrayList<Class>(this.usedIn.getOrDefault(cls, Collections.emptySet()));
        usedIn.sort(Comparator.comparing(c -> c.getSimpleName().toLowerCase(Locale.ENGLISH)));
        if (!usedIn.isEmpty()) {
            this.out.append("Used in: ");
            boolean first = true;
            for (Class usingClass : usedIn) {
                if (!first) {
                    this.out.append(", ");
                }
                this.typeLink(crd, this.out, usingClass);
                first = false;
            }
            this.out.append(NL);
            this.out.append(NL);
        }
    }

    private void appendDiscriminator(Crd crd, Class<?> cls) throws IOException {
        String discriminator = Property.discriminator(cls.getSuperclass());
        if (discriminator != null) {
            String subtypeLinks = Property.subtypes(cls.getSuperclass()).stream().filter(c -> !c.equals(cls)).map(c -> {
                try {
                    return this.typeLink(crd, (Class<?>)c);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.joining(", "));
            this.out.append("The `").append(discriminator).append("` property is a discriminator that distinguishes use of the `").append(cls.getSimpleName()).append("` type from ");
            if (subtypeLinks.trim().isEmpty()) {
                this.out.append("other subtypes which may be added in the future.");
            } else {
                this.out.append(subtypeLinks).append(".");
            }
            this.out.append(NL);
            this.out.append("It must have the value `").append(Property.subtypeMap(cls.getSuperclass()).get(cls)).append("` for the type `").append(cls.getSimpleName()).append("`.").append(NL);
        }
    }

    private void appendRepeated(char c, int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            this.out.append(c);
        }
    }

    public void typeLink(Crd crd, Appendable out, Class<?> cls) throws IOException {
        if (Short.TYPE.equals(cls) || Short.class.equals(cls) || Integer.TYPE.equals(cls) || Integer.class.equals(cls) || Long.TYPE.equals(cls) || Long.class.equals(cls)) {
            out.append("integer");
        } else if (Float.class.equals(cls) || Float.TYPE.equals(cls) || Double.class.equals(cls) || Double.TYPE.equals(cls)) {
            out.append("number");
        } else if (Object.class.equals(cls) || String.class.equals(cls) || Map.class.equals(cls) || Boolean.class.equals(cls) || Boolean.TYPE.equals(cls)) {
            out.append(cls.getSimpleName().toLowerCase(Locale.ENGLISH));
        } else if (Property.isPolymorphic(cls)) {
            out.append(Property.subtypes(cls).stream().map(c -> {
                try {
                    return this.typeLink(crd, (Class<?>)c);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.joining(", ")));
        } else {
            out.append("xref:").append(this.anchor(cls)).append("[`").append(cls.getSimpleName()).append("`]");
        }
    }

    public String typeLink(Crd crd, Class<?> cls) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.typeLink(crd, sb, cls);
        return sb.toString();
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Linker linker = null;
        File out = null;
        ArrayList<Class<? extends CustomResource>> classes = new ArrayList<Class<? extends CustomResource>>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if ("--linker".equals(arg)) {
                    String className;
                    Class<Linker> linkerClass;
                    if ((linkerClass = DocGenerator.classInherits(Class.forName(className = args[++i]), Linker.class)) != null) {
                        try {
                            linker = linkerClass.getConstructor(String.class).newInstance(args[++i]);
                            continue;
                        }
                        catch (ReflectiveOperationException reflectiveOperationException) {
                            throw new RuntimeException("--linker option can't be handled", reflectiveOperationException);
                        }
                    }
                    System.err.println(className + " is not a subclass of " + Linker.class.getName());
                    continue;
                }
                throw new RuntimeException("Unsupported option " + arg);
            }
            if (out == null) {
                out = new File(arg);
                continue;
            }
            Class<CustomResource> cls = DocGenerator.classInherits(Class.forName(arg), CustomResource.class);
            if (cls != null) {
                classes.add(cls);
                continue;
            }
            System.err.println(arg + " is not a subclass of " + CustomResource.class.getName());
        }
        ApiVersion crApiVersion = ApiVersion.V1BETA2;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8);){
            writer.append("// This file is auto-generated by ").append(DocGenerator.class.getName()).append(".").append(NL);
            writer.append("// To change this documentation you need to edit the Java sources.").append(NL);
            writer.append(NL);
            DocGenerator dg = new DocGenerator(crApiVersion, 1, classes, writer, linker);
            for (Class clazz : classes) {
                dg.generate(clazz);
            }
            if (dg.numErrors > 0) {
                System.err.println("There were " + dg.numErrors + " errors");
                System.exit(1);
            }
        }
    }

    static <T> Class<? extends T> classInherits(Class<?> cls, Class<T> test) {
        if (test.isAssignableFrom(cls)) {
            return cls;
        }
        return null;
    }
}

