/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka;

import io.fabric8.kubernetes.client.Client;
import org.apache.kafka.common.config.ConfigException;

final class KubernetesResourceIdentifier {
    private final String namespace;
    private final String name;

    private KubernetesResourceIdentifier(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public static KubernetesResourceIdentifier fromConfigString(Client client, String path) {
        if (!path.matches("([a-z0-9.-]+/)?[a-z0-9.-]+")) {
            throw new ConfigException("Invalid path " + path + ". It has to be in format <namespace>/<secret> (or <secret> for default namespace).");
        }
        String[] pathSegments = path.split("/");
        if (pathSegments.length == 1) {
            return new KubernetesResourceIdentifier(client.getNamespace(), pathSegments[0]);
        }
        if (pathSegments.length == 2) {
            return new KubernetesResourceIdentifier(pathSegments[0], pathSegments[1]);
        }
        throw new ConfigException("Invalid path " + path + ". It has to be in format <namespace>/<secret> (or <secret> for default namespace).");
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }
}

