/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import io.strimzi.kafka.oauth.common.ConfigException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class Config {
    public static final String OAUTH_CLIENT_ID = "oauth.client.id";
    public static final String OAUTH_CLIENT_SECRET = "oauth.client.secret";
    public static final String OAUTH_SCOPE = "oauth.scope";
    public static final String OAUTH_AUDIENCE = "oauth.audience";
    public static final String OAUTH_USERNAME_CLAIM = "oauth.username.claim";
    public static final String OAUTH_FALLBACK_USERNAME_CLAIM = "oauth.fallback.username.claim";
    public static final String OAUTH_FALLBACK_USERNAME_PREFIX = "oauth.fallback.username.prefix";
    public static final String OAUTH_SSL_TRUSTSTORE_LOCATION = "oauth.ssl.truststore.location";
    public static final String OAUTH_SSL_TRUSTSTORE_CERTIFICATES = "oauth.ssl.truststore.certificates";
    public static final String OAUTH_SSL_TRUSTSTORE_PASSWORD = "oauth.ssl.truststore.password";
    public static final String OAUTH_SSL_TRUSTSTORE_TYPE = "oauth.ssl.truststore.type";
    public static final String OAUTH_SSL_SECURE_RANDOM_IMPLEMENTATION = "oauth.ssl.secure.random.implementation";
    public static final String OAUTH_SSL_ENDPOINT_IDENTIFICATION_ALGORITHM = "oauth.ssl.endpoint.identification.algorithm";
    public static final String OAUTH_ACCESS_TOKEN_IS_JWT = "oauth.access.token.is.jwt";
    public static final String OAUTH_CONNECT_TIMEOUT_SECONDS = "oauth.connect.timeout.seconds";
    public static final String OAUTH_READ_TIMEOUT_SECONDS = "oauth.read.timeout.seconds";
    public static final String OAUTH_CONFIG_ID = "oauth.config.id";
    public static final String OAUTH_ENABLE_METRICS = "oauth.enable.metrics";
    @Deprecated
    public static final String OAUTH_TOKENS_NOT_JWT = "oauth.tokens.not.jwt";
    private Map<String, ?> defaults;

    public Config() {
    }

    public Config(Properties p) {
        this.defaults = p.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (v1, v2) -> v2, HashMap::new));
    }

    public Config(Map<String, ?> p) {
        this.defaults = Collections.unmodifiableMap(p);
    }

    public void validate() {
    }

    public String getValue(String key, String fallback) {
        String result = System.getProperty(key, null);
        if (result != null) {
            return result;
        }
        result = System.getenv(Config.toEnvName(key));
        if (result != null) {
            return result;
        }
        result = System.getenv(key);
        if (result != null) {
            return result;
        }
        if (this.defaults != null) {
            Object val = this.defaults.get(key);
            result = val != null ? String.valueOf(val) : null;
        }
        return result != null ? result : fallback;
    }

    public String getValue(String key) {
        return this.getValue(key, null);
    }

    public int getValueAsInt(String key, int fallback) {
        String result = this.getValue(key);
        return result != null ? Integer.parseInt(result) : fallback;
    }

    public long getValueAsLong(String key, long fallback) {
        String result = this.getValue(key);
        return result != null ? Long.parseLong(result) : fallback;
    }

    public boolean getValueAsBoolean(String key, boolean fallback) {
        String result = this.getValue(key);
        try {
            return result != null ? Config.isTrue(result) : fallback;
        }
        catch (Exception e) {
            throw new ConfigException("Bad boolean value for key: " + key + ", value: " + result);
        }
    }

    public URI getValueAsURI(String key) {
        String result = this.getValue(key);
        try {
            return URI.create(result);
        }
        catch (Exception e) {
            throw new ConfigException("Bad URI value for key: " + key + ", value: " + result, e);
        }
    }

    public static boolean isTrue(String result) {
        String val = result.toLowerCase(Locale.ENGLISH);
        if (val.equals("true") || val.equals("yes") || val.equals("y") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("no") || val.equals("n") || val.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Bad boolean value: " + result);
    }

    public static String toEnvName(String key) {
        return key.toUpperCase(Locale.ENGLISH).replace('-', '_').replace('.', '_');
    }
}

