/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.jsonpath;

import com.fasterxml.jackson.databind.JsonNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.strimzi.kafka.oauth.jsonpath.JsonPathQueryException;
import io.strimzi.kafka.oauth.jsonpath.Matcher;

public class JsonPathQuery {
    private final Matcher matcher;

    private JsonPathQuery(String query) {
        Configuration conf = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();
        ParseContext ctx = JsonPath.using((Configuration)conf);
        try {
            this.matcher = new Matcher(ctx, query, false);
        }
        catch (JsonPathException e) {
            throw new JsonPathQueryException("Failed to parse filter query: \"" + query + "\"", e);
        }
    }

    public static JsonPathQuery parse(String query) {
        return new JsonPathQuery(query);
    }

    public JsonNode apply(JsonNode jsonObject) {
        return this.matcher.apply(jsonObject);
    }

    public String toString() {
        return this.matcher.toString();
    }
}

