/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class Credentials {
    private final Map<String, LinkedList<KafkaPrincipal>> validatedCredentials = new HashMap<String, LinkedList<KafkaPrincipal>>();

    public synchronized void storeCredentials(String clientId, KafkaPrincipal principal) {
        LinkedList queue = this.validatedCredentials.computeIfAbsent(clientId, k -> new LinkedList());
        queue.add(principal);
    }

    public synchronized KafkaPrincipal takeCredentials(String clientId) {
        LinkedList<KafkaPrincipal> queue = this.validatedCredentials.get(clientId);
        if (queue == null) {
            return null;
        }
        KafkaPrincipal result = queue.poll();
        if (queue.size() == 0) {
            this.validatedCredentials.remove(clientId);
        }
        return result;
    }
}

