/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import io.strimzi.kafka.oauth.common.IOUtil;
import io.strimzi.kafka.oauth.common.TokenProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedTokenProvider
implements TokenProvider {
    private static final Logger log = LoggerFactory.getLogger(FileBasedTokenProvider.class);
    private final Path filePath;

    public FileBasedTokenProvider(String tokenFilePath) {
        this.filePath = Paths.get(tokenFilePath, new String[0]);
        try {
            if (!IOUtil.isFileAccessLimitedToOwner(this.filePath)) {
                log.warn("Permissions on token file should only give access to owner [{}]", (Object)this.filePath);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            log.warn("Failed to check permissions on token file [{}]:", (Object)this.filePath, (Object)e);
        }
    }

    @Override
    public String token() {
        try {
            return new String(Files.readAllBytes(this.filePath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return "FileBasedTokenProvider: {path: '" + String.valueOf(this.filePath) + "'}";
    }
}

