/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.zip.CRC32;

public class IOUtil {
    private static final Random RANDOM = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[4096];
        try {
            int rc;
            while ((rc = input.read(buf)) != -1) {
                output.write(buf, 0, rc);
            }
        }
        finally {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String randomHexString() {
        return IOUtil.randomHexString(8);
    }

    public static String randomHexString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(Integer.toHexString(RANDOM.nextInt(16)));
        }
        return sb.toString();
    }

    public static String asHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            int val = 0xFF & b;
            if (val < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString();
    }

    public static String hashForObjects(Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (Object o : args) {
            sb.append("|").append(o != null ? o : "\u0000\u0000\u0000");
        }
        String hex = IOUtil.asHexString(BigInteger.valueOf(IOUtil.crc32(sb.toString())).toByteArray());
        if (hex.length() == 8) {
            return hex;
        }
        if (hex.length() > 8) {
            return hex.substring(hex.length() - 8);
        }
        return String.format("%8s", hex).replace(' ', '0');
    }

    public static long crc32(String content) {
        CRC32 crc = new CRC32();
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        crc.update(bytes, 0, bytes.length);
        return crc.getValue();
    }

    public static boolean isFileAccessLimitedToOwner(Path file) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalArgumentException("No such file: " + String.valueOf(file.toAbsolutePath()));
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("File is not a regular file: " + String.valueOf(file.toAbsolutePath()));
        }
        FileSystem fs = FileSystems.getDefault();
        Set<String> supportedViews = fs.supportedFileAttributeViews();
        if (supportedViews.contains("posix")) {
            Set<PosixFilePermission> perms = Files.getPosixFilePermissions(file, new LinkOption[0]);
            List<PosixFilePermission> disallowed = Arrays.asList(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE, PosixFilePermission.OTHERS_EXECUTE);
            perms.retainAll(disallowed);
            return perms.isEmpty();
        }
        if (supportedViews.contains("acl")) {
            AclFileAttributeView view = Files.getFileAttributeView(file, AclFileAttributeView.class, new LinkOption[0]);
            UserPrincipal owner = view.getOwner();
            List<AclEntry> acl = view.getAcl();
            for (AclEntry entry : acl) {
                String permissionName = entry.principal().getName();
                if ("BUILTIN\\Administrators".equals(permissionName) || "NT AUTHORITY\\SYSTEM".equals(permissionName) || owner.getName().equals(permissionName) || !AclEntryType.ALLOW.equals((Object)entry.type())) continue;
                return false;
            }
            return true;
        }
        throw new RuntimeException("Not a POSIX or ACL compatible filesystem: " + String.valueOf(fs));
    }
}

