/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.common;

import com.fasterxml.jackson.databind.JsonNode;
import io.strimzi.kafka.oauth.common.JSONUtil;
import io.strimzi.kafka.oauth.jsonpath.JsonPathQuery;

public class PrincipalExtractor {
    private final Extractor usernameExtractor;
    private final String usernamePrefix;
    private final Extractor fallbackUsernameExtractor;
    private final String fallbackUsernamePrefix;

    public PrincipalExtractor() {
        this.usernameExtractor = null;
        this.usernamePrefix = null;
        this.fallbackUsernameExtractor = null;
        this.fallbackUsernamePrefix = null;
    }

    public PrincipalExtractor(String usernameClaim) {
        this.usernameExtractor = PrincipalExtractor.parseClaimSpec(usernameClaim);
        this.usernamePrefix = null;
        this.fallbackUsernameExtractor = null;
        this.fallbackUsernamePrefix = null;
    }

    public PrincipalExtractor(String usernameClaim, String usernamePrefix, String fallbackUsernameClaim, String fallbackUsernamePrefix) {
        this.usernameExtractor = PrincipalExtractor.parseClaimSpec(usernameClaim);
        this.usernamePrefix = usernamePrefix;
        this.fallbackUsernameExtractor = PrincipalExtractor.parseClaimSpec(fallbackUsernameClaim);
        this.fallbackUsernamePrefix = fallbackUsernamePrefix;
    }

    public String getPrincipal(JsonNode json) {
        if (this.usernameExtractor != null) {
            String result = this.extractUsername(this.usernameExtractor, json);
            if (result != null) {
                return this.usernamePrefix != null ? this.usernamePrefix + result : result;
            }
            if (this.fallbackUsernameExtractor != null) {
                result = this.extractUsername(this.fallbackUsernameExtractor, json);
                return result != null && this.fallbackUsernamePrefix != null ? this.fallbackUsernamePrefix + result : result;
            }
        }
        return null;
    }

    private String extractUsername(Extractor extractor, JsonNode json) {
        if (extractor.getAttributeName() != null) {
            String result = JSONUtil.getClaimFromJWT(json, extractor.getAttributeName());
            if (result != null && !result.isEmpty()) {
                return result;
            }
        } else {
            String result;
            JsonNode queryResult = extractor.getJSONPathQuery().apply(json);
            String string = result = queryResult == null ? null : queryResult.asText().trim();
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        return null;
    }

    public String getSub(JsonNode json) {
        return JSONUtil.getClaimFromJWT(json, "sub");
    }

    public String toString() {
        return "PrincipalExtractor {usernameClaim: " + String.valueOf(this.usernameExtractor) + ", usernamePrefix: " + this.usernamePrefix + ", fallbackUsernameClaim: " + String.valueOf(this.fallbackUsernameExtractor) + ", fallbackUsernamePrefix: " + this.fallbackUsernamePrefix + "}";
    }

    public boolean isConfigured() {
        return this.usernameExtractor != null || this.usernamePrefix != null || this.fallbackUsernameExtractor != null || this.fallbackUsernamePrefix != null;
    }

    private static Extractor parseClaimSpec(String spec) {
        String string = spec = spec == null ? null : spec.trim();
        if (spec == null || spec.isEmpty()) {
            return null;
        }
        if (!spec.startsWith("[")) {
            return new Extractor(spec);
        }
        return new Extractor(JsonPathQuery.parse(spec));
    }

    static class Extractor {
        private final String attributeName;
        private final JsonPathQuery query;

        private Extractor(JsonPathQuery query) {
            this.query = query;
            this.attributeName = null;
        }

        private Extractor(String attributeName) {
            this.attributeName = attributeName;
            this.query = null;
        }

        String getAttributeName() {
            return this.attributeName;
        }

        JsonPathQuery getJSONPathQuery() {
            return this.query;
        }

        public String toString() {
            return this.query != null ? this.query.toString() : this.attributeName;
        }
    }
}

