/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.metrics;

import io.strimzi.kafka.oauth.common.HttpException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.SSLException;

public class MetricsUtil {
    public static Map<String, String> getSensorKeyAttrs(String contextId, String mechanism, URI uri, String kind) {
        Map<String, String> attrs = MetricsUtil.getSensorKeyAttrs(contextId, uri, kind);
        attrs.put("mechanism", mechanism);
        return attrs;
    }

    public static Map<String, String> getSensorKeyAttrs(String contextId, URI uri, String kind) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("context", contextId);
        attrs.put("kind", kind);
        attrs.put("host", MetricsUtil.hostAttr(uri));
        attrs.put("path", MetricsUtil.pathAttr(uri));
        return attrs;
    }

    public static Map<String, String> addHttpSuccessAttrs(Map<String, String> attrs) {
        attrs.put("outcome", "success");
        attrs.put("status", "200");
        return attrs;
    }

    public static Map<String, String> addHttpErrorAttrs(Map<String, String> attrs, Throwable ex) {
        String errorType = "other";
        String status = null;
        if (ex instanceof HttpException) {
            HttpException e = (HttpException)ex;
            status = String.valueOf(e.getStatus());
            errorType = "http";
        } else if (ex instanceof SSLException) {
            errorType = "tls";
        } else if (ex instanceof IOException && ex.getCause() instanceof ConnectException) {
            errorType = "connect";
        }
        attrs.put("outcome", "error");
        attrs.put("error_type", errorType);
        if (status != null) {
            attrs.put("status", status);
        }
        return attrs;
    }

    public static String pathAttr(URI uri) {
        if (uri == null) {
            return "";
        }
        return uri.getRawPath();
    }

    public static String hostAttr(URI uri) {
        if (uri == null) {
            return "";
        }
        int port = uri.getPort();
        if (port == -1) {
            String scheme = uri.getScheme();
            if (scheme.equals("http")) {
                port = 80;
            } else if (scheme.equals("https")) {
                port = 443;
            }
        }
        return uri.getHost() + (String)(port != -1 ? ":" + port : "");
    }
}

