/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class SensorKey {
    private static final String[] SORTED_ATTRIBUTES = new String[]{"context", "kind", "host", "path"};
    final String name;
    final Map<String, String> attributes;
    final String id;

    public static SensorKey of(String name, Map<String, String> attributes) {
        return new SensorKey(name, attributes);
    }

    public static SensorKey of(String name, String ... attributes) {
        if (attributes.length == 0) {
            throw new IllegalArgumentException("There should be some attributes");
        }
        if (attributes.length % 2 != 0) {
            throw new IllegalArgumentException("There should be an even number of attributes");
        }
        LinkedHashMap<String, String> attrMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < attributes.length; i += 2) {
            attrMap.put(attributes[i], attributes[i + 1]);
        }
        return new SensorKey(name, attrMap);
    }

    private SensorKey(String name, Map<String, String> attributes) {
        this.name = name;
        this.attributes = Collections.unmodifiableMap(this.sortAttributes(attributes));
        this.id = name + String.valueOf(attributes);
    }

    private LinkedHashMap<String, String> sortAttributes(Map<String, String> attributes) {
        TreeMap<String, String> ordered = new TreeMap<String, String>(attributes);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String key : SORTED_ATTRIBUTES) {
            result.put(key, this.requireKey(ordered, key));
        }
        result.putAll(ordered);
        return result;
    }

    private String requireKey(TreeMap<String, String> ordered, String key) {
        String value = ordered.remove(key);
        if (value == null) {
            throw new IllegalArgumentException("The required attribute is missing: " + key);
        }
        return value;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SensorKey sensorKey = (SensorKey)o;
        return Objects.equals(this.name, sensorKey.name) && Objects.equals(this.attributes, sensorKey.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.attributes);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + " " + this.id;
    }
}

