/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.services;

import io.strimzi.kafka.oauth.common.IOUtil;
import io.strimzi.kafka.oauth.common.LogUtil;
import java.util.Objects;

public class ValidatorKey {
    private final String clientId;
    private final String clientSecret;
    private final String bearerToken;
    private final String validIssuerUri;
    private final String audience;
    private final String customClaimCheck;
    private final String usernameClaim;
    private final String fallbackUsernameClaim;
    private final String fallbackUsernamePrefix;
    private final String groupQuery;
    private final String groupDelimiter;
    private final String sslTruststore;
    private final String sslStorePassword;
    private final String sslStoreType;
    private final String sslRandom;
    private final boolean hasHostnameVerifier;
    private final int connectTimeout;
    private final int readTimeout;
    private final boolean enableMetrics;
    private final boolean includeAcceptHeader;
    private final String configIdHash;

    ValidatorKey(String clientId, String clientSecret, String bearerToken, String validIssuerUri, String audience, String customClaimCheck, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String groupQuery, String groupDelimiter, String sslTruststore, String sslStorePassword, String sslStoreType, String sslRandom, boolean hasHostnameVerifier, int connectTimeout, int readTimeout, boolean enableMetrics, boolean includeAcceptHeader) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.bearerToken = bearerToken;
        this.validIssuerUri = validIssuerUri;
        this.audience = audience;
        this.customClaimCheck = customClaimCheck;
        this.usernameClaim = usernameClaim;
        this.fallbackUsernameClaim = fallbackUsernameClaim;
        this.fallbackUsernamePrefix = fallbackUsernamePrefix;
        this.groupQuery = groupQuery;
        this.groupDelimiter = groupDelimiter;
        this.sslTruststore = sslTruststore;
        this.sslStorePassword = sslStorePassword;
        this.sslStoreType = sslStoreType;
        this.sslRandom = sslRandom;
        this.hasHostnameVerifier = hasHostnameVerifier;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.enableMetrics = enableMetrics;
        this.includeAcceptHeader = includeAcceptHeader;
        this.configIdHash = IOUtil.hashForObjects(clientId, clientSecret, bearerToken, validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, groupQuery, groupDelimiter, sslTruststore, sslStorePassword, sslStoreType, sslRandom, hasHostnameVerifier, connectTimeout, readTimeout, enableMetrics, includeAcceptHeader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidatorKey)) {
            return false;
        }
        ValidatorKey that = (ValidatorKey)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.bearerToken, that.bearerToken) && this.hasHostnameVerifier == that.hasHostnameVerifier && Objects.equals(this.validIssuerUri, that.validIssuerUri) && Objects.equals(this.audience, that.audience) && Objects.equals(this.customClaimCheck, that.customClaimCheck) && Objects.equals(this.usernameClaim, that.usernameClaim) && Objects.equals(this.fallbackUsernameClaim, that.fallbackUsernameClaim) && Objects.equals(this.fallbackUsernamePrefix, that.fallbackUsernamePrefix) && Objects.equals(this.groupQuery, that.groupQuery) && Objects.equals(this.groupDelimiter, that.groupDelimiter) && Objects.equals(this.sslTruststore, that.sslTruststore) && Objects.equals(this.sslStorePassword, that.sslStorePassword) && Objects.equals(this.sslStoreType, that.sslStoreType) && Objects.equals(this.sslRandom, that.sslRandom) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.enableMetrics, that.enableMetrics) && Objects.equals(this.includeAcceptHeader, that.includeAcceptHeader);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.bearerToken, this.validIssuerUri, this.audience, this.customClaimCheck, this.usernameClaim, this.fallbackUsernameClaim, this.fallbackUsernamePrefix, this.groupQuery, this.groupDelimiter, this.sslTruststore, this.sslStorePassword, this.sslStoreType, this.sslRandom, this.hasHostnameVerifier, this.connectTimeout, this.readTimeout, this.enableMetrics, this.includeAcceptHeader);
    }

    public String getConfigIdHash() {
        return this.configIdHash;
    }

    public static class IntrospectionValidatorKey
    extends ValidatorKey {
        private final String introspectionEndpoint;
        private final String userInfoEndpoint;
        private final String validTokenType;
        private final int retries;
        private final long retryPauseMillis;
        private final String configIdHash;

        public IntrospectionValidatorKey(String clientId, String clientSecret, String bearerToken, String validIssuerUri, String audience, String customClaimCheck, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String groupQuery, String groupDelimiter, String sslTruststore, String sslStorePassword, String sslStoreType, String sslRandom, boolean hasHostnameVerifier, String introspectionEndpoint, String userInfoEndpoint, String validTokenType, int connectTimeout, int readTimeout, boolean enableMetrics, int retries, long retryPauseMillis, boolean includeAcceptHeader) {
            super(clientId, clientSecret, bearerToken, validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, groupQuery, groupDelimiter, sslTruststore, sslStorePassword, sslStoreType, sslRandom, hasHostnameVerifier, connectTimeout, readTimeout, enableMetrics, includeAcceptHeader);
            this.introspectionEndpoint = introspectionEndpoint;
            this.userInfoEndpoint = userInfoEndpoint;
            this.validTokenType = validTokenType;
            this.retries = retries;
            this.retryPauseMillis = retryPauseMillis;
            this.configIdHash = IOUtil.hashForObjects(super.getConfigIdHash(), introspectionEndpoint, userInfoEndpoint, validTokenType, clientId, clientSecret, retries, retryPauseMillis);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            IntrospectionValidatorKey that = (IntrospectionValidatorKey)o;
            return Objects.equals(this.introspectionEndpoint, that.introspectionEndpoint) && Objects.equals(this.userInfoEndpoint, that.userInfoEndpoint) && Objects.equals(this.validTokenType, that.validTokenType) && Objects.equals(this.retries, that.retries) && Objects.equals(this.retryPauseMillis, that.retryPauseMillis);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.introspectionEndpoint, this.userInfoEndpoint, this.validTokenType, this.retries, this.retryPauseMillis);
        }

        @Override
        public String getConfigIdHash() {
            return this.configIdHash;
        }

        public String toString() {
            return "IntrospectionValidatorKey {clientId: " + LogUtil.singleQuote(this.clientId) + ", clientSecret: " + LogUtil.singleQuote(LogUtil.mask(this.clientSecret)) + ", bearerToken: " + LogUtil.singleQuote(LogUtil.mask(this.bearerToken)) + ", validIssuerUri: " + LogUtil.singleQuote(this.validIssuerUri) + ", audience: " + LogUtil.singleQuote(this.audience) + ", customClaimCheck: " + LogUtil.singleQuote(this.customClaimCheck) + ", usernameClaim: " + LogUtil.singleQuote(this.usernameClaim) + ", fallbackUsernameClaim: " + LogUtil.singleQuote(this.fallbackUsernameClaim) + ", fallbackUsernamePrefix: " + LogUtil.singleQuote(this.fallbackUsernamePrefix) + ", groupQuery: " + LogUtil.singleQuote(this.groupQuery) + ", groupDelimiter: [" + this.groupDelimiter + "], sslTruststore: " + LogUtil.singleQuote(this.sslTruststore) + ", sslStorePassword: " + LogUtil.singleQuote(LogUtil.mask(this.sslStorePassword)) + ", sslStoreType: " + LogUtil.singleQuote(this.sslStoreType) + ", sslRandom: " + LogUtil.singleQuote(this.sslRandom) + ", hasHostnameVerifier: " + this.hasHostnameVerifier + ", connectTimeout: " + this.connectTimeout + ", readTimeout: " + this.readTimeout + ", enableMetrics: " + this.enableMetrics + ", includeAcceptHeader: " + this.includeAcceptHeader + ", introspectionEndpoint: " + LogUtil.singleQuote(this.introspectionEndpoint) + ", userInfoEndpoint: " + LogUtil.singleQuote(this.userInfoEndpoint) + ", validTokenType: " + LogUtil.singleQuote(this.validTokenType) + ", retries: " + this.retries + ", retryPauseMillis: " + this.retryPauseMillis + "}";
        }
    }

    public static class JwtValidatorKey
    extends ValidatorKey {
        private final String jwksEndpointUri;
        private final int jwksRefreshSeconds;
        private final int jwksExpirySeconds;
        private final int jwksRefreshMinPauseSeconds;
        private final boolean checkAccessTokenType;
        private final boolean failFast;
        private final boolean jwksIgnoreKeyUse;
        private final String configIdHash;

        public JwtValidatorKey(String clientId, String clientSecret, String bearerToken, String validIssuerUri, String audience, String customClaimCheck, String usernameClaim, String fallbackUsernameClaim, String fallbackUsernamePrefix, String groupQuery, String groupDelimiter, String sslTruststore, String sslStorePassword, String sslStoreType, String sslRandom, boolean hasHostnameVerifier, String jwksEndpointUri, int jwksRefreshSeconds, int jwksExpirySeconds, int jwksRefreshMinPauseSeconds, boolean jwksIgnoreKeyUse, boolean checkAccessTokenType, int connectTimeout, int readTimeout, boolean enableMetrics, boolean failFast, boolean includeAcceptHeader) {
            super(clientId, clientSecret, bearerToken, validIssuerUri, audience, customClaimCheck, usernameClaim, fallbackUsernameClaim, fallbackUsernamePrefix, groupQuery, groupDelimiter, sslTruststore, sslStorePassword, sslStoreType, sslRandom, hasHostnameVerifier, connectTimeout, readTimeout, enableMetrics, includeAcceptHeader);
            this.jwksEndpointUri = jwksEndpointUri;
            this.jwksRefreshSeconds = jwksRefreshSeconds;
            this.jwksExpirySeconds = jwksExpirySeconds;
            this.jwksRefreshMinPauseSeconds = jwksRefreshMinPauseSeconds;
            this.jwksIgnoreKeyUse = jwksIgnoreKeyUse;
            this.checkAccessTokenType = checkAccessTokenType;
            this.failFast = failFast;
            this.configIdHash = IOUtil.hashForObjects(super.getConfigIdHash(), jwksEndpointUri, jwksRefreshSeconds, jwksExpirySeconds, jwksRefreshMinPauseSeconds, jwksIgnoreKeyUse, checkAccessTokenType, failFast);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            JwtValidatorKey that = (JwtValidatorKey)o;
            return this.jwksRefreshSeconds == that.jwksRefreshSeconds && this.jwksExpirySeconds == that.jwksExpirySeconds && this.jwksRefreshMinPauseSeconds == that.jwksRefreshMinPauseSeconds && this.jwksIgnoreKeyUse == that.jwksIgnoreKeyUse && this.checkAccessTokenType == that.checkAccessTokenType && this.failFast == that.failFast && Objects.equals(this.jwksEndpointUri, that.jwksEndpointUri);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.jwksEndpointUri, this.jwksRefreshSeconds, this.jwksExpirySeconds, this.jwksRefreshMinPauseSeconds, this.jwksIgnoreKeyUse, this.checkAccessTokenType, this.failFast);
        }

        @Override
        public String getConfigIdHash() {
            return this.configIdHash;
        }

        public String toString() {
            return "JwtValidatorKey {clientId: " + LogUtil.singleQuote(this.clientId) + ", clientSecret: " + LogUtil.singleQuote(LogUtil.mask(this.clientSecret)) + ", bearerToken: " + LogUtil.singleQuote(LogUtil.mask(this.bearerToken)) + ", validIssuerUri: " + LogUtil.singleQuote(this.validIssuerUri) + ", audience: " + LogUtil.singleQuote(this.audience) + ", customClaimCheck: " + LogUtil.singleQuote(this.customClaimCheck) + ", usernameClaim: " + LogUtil.singleQuote(this.usernameClaim) + ", fallbackUsernameClaim: " + LogUtil.singleQuote(this.fallbackUsernameClaim) + ", fallbackUsernamePrefix: " + LogUtil.singleQuote(this.fallbackUsernamePrefix) + ", groupQuery: " + LogUtil.singleQuote(this.groupQuery) + ", groupDelimiter: [" + this.groupDelimiter + "], sslTruststore: " + LogUtil.singleQuote(this.sslTruststore) + ", sslStorePassword: " + LogUtil.singleQuote(LogUtil.mask(this.sslStorePassword)) + ", sslStoreType: " + LogUtil.singleQuote(this.sslStoreType) + ", sslRandom: " + LogUtil.singleQuote(this.sslRandom) + ", hasHostnameVerifier: " + this.hasHostnameVerifier + ", connectTimeout: " + this.connectTimeout + ", readTimeout: " + this.readTimeout + ", enableMetrics: " + this.enableMetrics + ", includeAcceptHeader: " + this.includeAcceptHeader + ", jwksEndpointUri: " + LogUtil.singleQuote(this.jwksEndpointUri) + ", jwksRefreshSeconds: " + this.jwksRefreshSeconds + ", jwksExpirySeconds: " + this.jwksExpirySeconds + ", jwksRefreshMinPauseSeconds: " + this.jwksRefreshMinPauseSeconds + ", jwksIgnoreKeyUse: " + this.jwksIgnoreKeyUse + ", checkAccessTokenType: " + this.checkAccessTokenType + ", failFast: " + this.failFast + "}";
        }
    }
}

