/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.model.Annotatable;
import io.sundr.model.AnnotationRef;
import io.sundr.model.AttributeKey;
import io.sundr.model.ClassRef;
import io.sundr.model.Commentable;
import io.sundr.model.Kind;
import io.sundr.model.Mappable;
import io.sundr.model.Method;
import io.sundr.model.ModifierSupport;
import io.sundr.model.Nameable;
import io.sundr.model.Property;
import io.sundr.model.Renderable;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeRef;
import io.sundr.model.WildcardRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeDef
extends ModifierSupport
implements Renderable,
Nameable,
Annotatable,
Commentable,
Mappable<TypeDef> {
    public static TypeDef OBJECT = new TypeDef("java.lang.Object");
    public static TypeDef ENUM = new TypeDef("java.lang.Enum");
    public static ClassRef OBJECT_REF = OBJECT.toReference(new TypeRef[0]);
    public static ClassRef ENUM_REF = ENUM.toReference(new TypeRef[0]);
    private final Kind kind;
    private final String packageName;
    private final String name;
    private final List<String> comments;
    private final List<AnnotationRef> annotations;
    private final List<ClassRef> extendsList;
    private final List<ClassRef> implementsList;
    private final List<TypeParamDef> parameters;
    private final List<Property> properties;
    private final List<Method> constructors;
    private final List<Method> methods;
    private final String outerTypeName;
    private final List<TypeDef> innerTypes;

    public TypeDef(Kind kind, String packageName, String name, List<String> comments, List<AnnotationRef> annotations, List<ClassRef> extendsList, List<ClassRef> implementsList, List<TypeParamDef> parameters, List<Property> properties, List<Method> constructors, List<Method> methods, String outerTypeName, List<TypeDef> innerTypes, int modifiers, Map<AttributeKey, Object> attributes) {
        super(modifiers, attributes);
        this.kind = kind != null ? kind : Kind.CLASS;
        this.packageName = packageName;
        this.name = name;
        this.comments = comments;
        this.annotations = annotations;
        this.extendsList = extendsList;
        this.implementsList = implementsList;
        this.parameters = parameters;
        this.properties = properties;
        this.constructors = TypeDef.adaptConstructors(constructors, this);
        this.methods = methods;
        this.outerTypeName = outerTypeName;
        this.innerTypes = TypeDef.setOuterType(innerTypes, this);
    }

    protected TypeDef(String fullyQualifiedName) {
        super(1, Collections.emptyMap());
        this.kind = Kind.CLASS;
        this.name = Nameable.getClassName(fullyQualifiedName);
        this.packageName = Nameable.getPackageName(fullyQualifiedName);
        this.comments = Collections.emptyList();
        this.annotations = Collections.emptyList();
        this.extendsList = Collections.emptyList();
        this.implementsList = Collections.emptyList();
        this.parameters = Collections.emptyList();
        this.properties = Collections.emptyList();
        this.constructors = Collections.emptyList();
        this.methods = Collections.emptyList();
        this.innerTypes = Collections.emptyList();
        this.outerTypeName = null;
    }

    public static TypeDef forName(String fullyQualifiedName) {
        return new TypeDef(fullyQualifiedName);
    }

    private static List<Method> adaptConstructors(List<Method> methods, TypeDef target) {
        ArrayList<Method> adapted = new ArrayList<Method>();
        for (Method m : methods) {
            adapted.add(new Method(m.getComments(), m.getAnnotations(), m.getParameters(), null, target.toUnboundedReference(), m.getArguments(), m.isVarArgPreferred(), m.getExceptions(), false, m.getBlock(), m.getModifiers(), m.getAttributes()));
        }
        return adapted;
    }

    private static List<TypeDef> setOuterType(List<TypeDef> types, TypeDef outer) {
        if (types == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeDef> updated = new ArrayList<TypeDef>();
        for (TypeDef typeDef : types) {
            if (outer.getFullyQualifiedName().equals(typeDef.getOuterTypeName())) {
                updated.add(typeDef);
                continue;
            }
            updated.add(new TypeDef(typeDef.getKind(), outer.getPackageName(), typeDef.getName(), typeDef.getComments(), typeDef.getAnnotations(), typeDef.getExtendsList(), typeDef.getImplementsList(), typeDef.getParameters(), typeDef.getProperties(), typeDef.getConstructors(), typeDef.getMethods(), outer.getFullyQualifiedName(), typeDef.getInnerTypes(), typeDef.getModifiers(), typeDef.getAttributes()));
        }
        return updated;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder sb = new StringBuilder();
        if (this.packageName != null && !this.packageName.isEmpty() && (this.outerTypeName == null || this.outerTypeName.isEmpty())) {
            sb.append(this.getPackageName()).append(".");
        }
        if (this.outerTypeName != null) {
            sb.append(this.outerTypeName).append(".");
        }
        sb.append(this.getName());
        return sb.toString();
    }

    public Kind getKind() {
        return this.kind;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    public List<AnnotationRef> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<ClassRef> getExtendsList() {
        return this.extendsList;
    }

    public List<ClassRef> getImplementsList() {
        return this.implementsList;
    }

    public List<TypeParamDef> getParameters() {
        return this.parameters;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Method> getConstructors() {
        return this.constructors;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public String getOuterTypeName() {
        return this.outerTypeName;
    }

    public List<TypeDef> getInnerTypes() {
        return this.innerTypes;
    }

    public boolean isClass() {
        return this.kind == Kind.CLASS;
    }

    public boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    public boolean isEnum() {
        return this.kind == Kind.ENUM || this.kind == Kind.CLASS && this.extendsList.contains(ENUM_REF);
    }

    public boolean isAnnotation() {
        return this.kind == Kind.ANNOTATION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDef typeDef = (TypeDef)o;
        if (this.packageName != null ? !this.packageName.equals(typeDef.packageName) : typeDef.packageName != null) {
            return false;
        }
        if (this.outerTypeName != null ? !this.outerTypeName.equals(typeDef.outerTypeName) : typeDef.outerTypeName != null) {
            return false;
        }
        return this.name != null ? this.name.equals(typeDef.name) : typeDef.name == null;
    }

    public int hashCode() {
        int result = this.packageName != null ? this.packageName.hashCode() : 0;
        result = 31 * result + (this.outerTypeName != null ? this.outerTypeName.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public ClassRef toReference(TypeRef ... arguments) {
        return this.toReference(Arrays.asList(arguments));
    }

    public ClassRef toReference(List<TypeRef> arguments) {
        ArrayList<TypeRef> actualArguments = new ArrayList<TypeRef>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i < arguments.size()) {
                actualArguments.add(arguments.get(i));
                continue;
            }
            actualArguments.add(new WildcardRef());
        }
        return new ClassRef(this.getFullyQualifiedName(), 0, actualArguments, this.getAttributes());
    }

    public ClassRef toReference(Collection<TypeRef> arguments) {
        return this.toReference((List<TypeRef>)new ArrayList<TypeRef>(arguments));
    }

    public ClassRef toInternalReference() {
        ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
        for (TypeParamDef parameter : this.parameters) {
            arguments.add(parameter.toReference());
        }
        return new ClassRef(this.getFullyQualifiedName(), 0, arguments, this.getAttributes());
    }

    public ClassRef toUnboundedReference() {
        return new ClassRef(this.getFullyQualifiedName(), 0, Collections.emptyList(), this.getAttributes());
    }

    public Set<String> getImports() {
        LinkedHashSet<String> imports = new LinkedHashSet<String>();
        for (ClassRef ref : this.getReferenceMap().values()) {
            if (ref.getPackageName() == null || ref.getPackageName().isEmpty() || ref.getPackageName().equals(this.packageName) || ref.getName().equals(this.name) || ref.getFullyQualifiedName().startsWith("com.ibm.jit.JITHelpers") || ref.getFullyQualifiedName().equals("java.lang.StringCompressionFlag")) continue;
            imports.add(ref.getFullyQualifiedName());
        }
        return imports;
    }

    private Map<String, ClassRef> getReferenceMap() {
        HashMap<String, ClassRef> mapping = new HashMap<String, ClassRef>();
        List<ClassRef> refs = this.getReferences();
        Collections.sort(refs, new Comparator<ClassRef>(){

            @Override
            public int compare(ClassRef o1, ClassRef o2) {
                return o1.getFullyQualifiedName().compareTo(o2.getFullyQualifiedName());
            }
        });
        for (ClassRef ref : refs) {
            String key = ref.getName();
            if (mapping.containsKey(key)) continue;
            mapping.put(key, ref);
        }
        return mapping;
    }

    public List<ClassRef> getReferences() {
        ArrayList<ClassRef> refs = new ArrayList<ClassRef>();
        for (AnnotationRef a : this.annotations) {
            refs.addAll(a.getReferences());
        }
        for (ClassRef i : this.implementsList) {
            refs.addAll(i.getReferences());
        }
        for (ClassRef e : this.extendsList) {
            refs.addAll(e.getReferences());
        }
        for (Property property : this.properties) {
            refs.addAll(property.getReferences());
        }
        for (Method method : this.constructors) {
            refs.addAll(method.getReferences());
        }
        for (Method method : this.methods) {
            refs.addAll(method.getReferences());
        }
        for (TypeParamDef typeParamDef : this.parameters) {
            for (ClassRef bound : typeParamDef.getBounds()) {
                refs.addAll(bound.getReferences());
            }
        }
        for (TypeDef innerType : this.innerTypes) {
            refs.addAll(innerType.getReferences());
        }
        if (this.getAttributes().containsKey(ALSO_IMPORT)) {
            Object obj = this.getAttributes().get(ALSO_IMPORT);
            if (obj instanceof ClassRef) {
                refs.add((ClassRef)obj);
            } else if (obj instanceof Collection) {
                refs.addAll((Collection)obj);
            }
        }
        return refs;
    }

    public String renderDefinition() {
        StringBuilder sb = new StringBuilder();
        this.renderDefinition(sb);
        return sb.toString();
    }

    public void renderDefinition(StringBuilder sb) {
        this.renderModifiers(sb);
        sb.append(this.kind.name().toLowerCase()).append(" ");
        sb.append(this.name);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("<");
            sb.append(this.parameters.stream().map((? super T p) -> p.render(this)).collect(Collectors.joining(",")));
            sb.append(">");
        }
        if (!(this.extendsList == null || this.extendsList.isEmpty() || this.extendsList.size() == 1 && this.extendsList.contains(OBJECT.toReference(new TypeRef[0])))) {
            sb.append(" ").append("extends").append(" ");
            sb.append(this.extendsList.stream().map((? super T e) -> e.render(this)).collect(Collectors.joining(",")));
        }
        if (this.implementsList != null && !this.implementsList.isEmpty()) {
            sb.append(" ").append("implements").append(" ");
            sb.append(this.implementsList.stream().map((? super T i) -> i.render(this)).collect(Collectors.joining(",")));
        }
    }

    @Override
    public String render() {
        String halfIndent;
        StringBuilder sb = new StringBuilder();
        String indent = this.outerTypeName == null ? "  " : "    ";
        String string = halfIndent = this.outerTypeName == null ? "" : "  ";
        if (this.outerTypeName == null) {
            sb.append("package ").append(this.getPackageName()).append(";").append("\n");
            sb.append("\n");
            for (String i : this.getImports()) {
                sb.append("import ").append(i).append(";").append("\n");
            }
        }
        if (this.comments != null && !this.comments.isEmpty()) {
            sb.append(this.renderComments(" "));
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append(this.renderAnnotations(indent));
        }
        this.renderDefinition(sb);
        sb.append("{").append("\n").append(indent);
        if (this.kind != Kind.INTERFACE) {
            for (Method constructors : this.getConstructors()) {
                sb.append(constructors.renderComments(indent));
                sb.append(constructors.renderAnnotations(indent));
                sb.append(constructors.render(this));
                sb.append("\n").append(indent);
            }
            for (Property field : this.getProperties()) {
                sb.append(field.renderComments(indent));
                sb.append(field.renderAnnotations(indent));
                sb.append(field.render(this));
                if (field.getAttribute(INIT) != null) {
                    sb.append(" = ").append(field.getDefaultValue());
                }
                sb.append(";").append("\n").append(indent);
            }
        }
        for (Method method : this.getMethods()) {
            sb.append(method.renderComments(indent));
            sb.append(method.renderAnnotations(indent));
            sb.append(method.render(this));
            sb.append("\n").append(indent);
        }
        for (TypeDef innerType : this.innerTypes) {
            sb.append(innerType.render());
            sb.append("\n").append(indent);
        }
        sb.append("\n").append(halfIndent).append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AnnotationRef annotationRef : this.annotations) {
            sb.append(annotationRef.toString()).append(" ");
        }
        this.renderModifiers(sb);
        sb.append(this.kind.name().toLowerCase()).append(" ");
        sb.append(this.name);
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sb.append("<");
            sb.append(this.parameters.stream().map(Object::toString).collect(Collectors.joining(",")));
            sb.append(">");
        }
        if (!(this.extendsList == null || this.extendsList.isEmpty() || this.extendsList.size() == 1 && this.extendsList.contains(OBJECT.toReference(new TypeRef[0])))) {
            sb.append(" ").append("extends").append(" ");
            sb.append(this.extendsList.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (this.implementsList != null && !this.implementsList.isEmpty()) {
            sb.append(" ").append("implements").append(" ");
            sb.append(this.implementsList.stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }
}

