/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model;

import io.sundr.builder.Nested;
import io.sundr.model.AttributeSupportFluentImpl;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.ClassRefFluentImpl;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamDefFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class TypeParamDefFluentImpl<A extends TypeParamDefFluent<A>>
extends AttributeSupportFluentImpl<A>
implements TypeParamDefFluent<A> {
    private String name;
    private List<ClassRefBuilder> bounds = new ArrayList<ClassRefBuilder>();

    public TypeParamDefFluentImpl() {
    }

    public TypeParamDefFluentImpl(TypeParamDef instance) {
        this.withName(instance.getName());
        this.withBounds(instance.getBounds());
        this.withAttributes(instance.getAttributes());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(int[] arg1, int arg2, int arg3) {
        return this.withName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewName(char[] arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(byte[] arg1, int arg2) {
        return this.withName(new String(arg1, arg2));
    }

    @Override
    public A withNewName(byte[] arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(char[] arg1, int arg2, int arg3) {
        return this.withName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewName(byte[] arg1, int arg2, int arg3) {
        return this.withName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewName(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withName(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A addToBounds(int index, ClassRef item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<ClassRefBuilder>();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        this._visitables.get((Object)"bounds").add(index >= 0 ? index : this._visitables.get((Object)"bounds").size(), builder);
        this.bounds.add(index >= 0 ? index : this.bounds.size(), builder);
        return (A)this;
    }

    @Override
    public A setToBounds(int index, ClassRef item) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<ClassRefBuilder>();
        }
        ClassRefBuilder builder = new ClassRefBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"bounds").size()) {
            this._visitables.get((Object)"bounds").add(builder);
        } else {
            this._visitables.get((Object)"bounds").set(index, builder);
        }
        if (index < 0 || index >= this.bounds.size()) {
            this.bounds.add(builder);
        } else {
            this.bounds.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToBounds(ClassRef ... items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<ClassRefBuilder>();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToBounds(Collection<ClassRef> items) {
        if (this.bounds == null) {
            this.bounds = new ArrayList<ClassRefBuilder>();
        }
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").add(builder);
            this.bounds.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromBounds(ClassRef ... items) {
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").remove(builder);
            if (this.bounds == null) continue;
            this.bounds.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBounds(Collection<ClassRef> items) {
        for (ClassRef item : items) {
            ClassRefBuilder builder = new ClassRefBuilder(item);
            this._visitables.get((Object)"bounds").remove(builder);
            if (this.bounds == null) continue;
            this.bounds.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromBounds(Predicate<ClassRefBuilder> predicate) {
        if (this.bounds == null) {
            return (A)this;
        }
        Iterator<ClassRefBuilder> each = this.bounds.iterator();
        List visitables = this._visitables.get((Object)"bounds");
        while (each.hasNext()) {
            ClassRefBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClassRef> getBounds() {
        return TypeParamDefFluentImpl.build(this.bounds);
    }

    @Override
    public List<ClassRef> buildBounds() {
        return TypeParamDefFluentImpl.build(this.bounds);
    }

    @Override
    public ClassRef buildBound(int index) {
        return this.bounds.get(index).build();
    }

    @Override
    public ClassRef buildFirstBound() {
        return this.bounds.get(0).build();
    }

    @Override
    public ClassRef buildLastBound() {
        return this.bounds.get(this.bounds.size() - 1).build();
    }

    @Override
    public ClassRef buildMatchingBound(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.bounds) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBound(Predicate<ClassRefBuilder> predicate) {
        for (ClassRefBuilder item : this.bounds) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBounds(List<ClassRef> bounds) {
        if (this.bounds != null) {
            this._visitables.get((Object)"bounds").removeAll(this.bounds);
        }
        if (bounds != null) {
            this.bounds = new ArrayList<ClassRefBuilder>();
            for (ClassRef item : bounds) {
                this.addToBounds(item);
            }
        } else {
            this.bounds = null;
        }
        return (A)this;
    }

    @Override
    public A withBounds(ClassRef ... bounds) {
        if (this.bounds != null) {
            this.bounds.clear();
        }
        if (bounds != null) {
            for (ClassRef item : bounds) {
                this.addToBounds(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBounds() {
        return this.bounds != null && !this.bounds.isEmpty();
    }

    @Override
    public TypeParamDefFluent.BoundsNested<A> addNewBound() {
        return new BoundsNestedImpl();
    }

    @Override
    public TypeParamDefFluent.BoundsNested<A> addNewBoundLike(ClassRef item) {
        return new BoundsNestedImpl(-1, item);
    }

    @Override
    public TypeParamDefFluent.BoundsNested<A> setNewBoundLike(int index, ClassRef item) {
        return new BoundsNestedImpl(index, item);
    }

    @Override
    public TypeParamDefFluent.BoundsNested<A> editBound(int index) {
        if (this.bounds.size() <= index) {
            throw new RuntimeException("Can't edit bounds. Index exceeds size.");
        }
        return this.setNewBoundLike(index, this.buildBound(index));
    }

    @Override
    public TypeParamDefFluent.BoundsNested<A> editFirstBound() {
        if (this.bounds.size() == 0) {
            throw new RuntimeException("Can't edit first bounds. The list is empty.");
        }
        return this.setNewBoundLike(0, this.buildBound(0));
    }

    @Override
    public TypeParamDefFluent.BoundsNested<A> editLastBound() {
        int index = this.bounds.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last bounds. The list is empty.");
        }
        return this.setNewBoundLike(index, this.buildBound(index));
    }

    @Override
    public TypeParamDefFluent.BoundsNested<A> editMatchingBound(Predicate<ClassRefBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.bounds.size(); ++i) {
            if (!predicate.test(this.bounds.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching bounds. No match found.");
        }
        return this.setNewBoundLike(index, this.buildBound(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeParamDefFluentImpl that = (TypeParamDefFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.bounds != null ? !this.bounds.equals(that.bounds) : that.bounds != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.bounds, super.hashCode());
    }

    public class BoundsNestedImpl<N>
    extends ClassRefFluentImpl<TypeParamDefFluent.BoundsNested<N>>
    implements TypeParamDefFluent.BoundsNested<N>,
    Nested<N> {
        private final ClassRefBuilder builder;
        private final int index;

        BoundsNestedImpl(int index, ClassRef item) {
            this.index = index;
            this.builder = new ClassRefBuilder(this, item);
        }

        BoundsNestedImpl() {
            this.index = -1;
            this.builder = new ClassRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)TypeParamDefFluentImpl.this.setToBounds(this.index, this.builder.build());
        }

        @Override
        public N endBound() {
            return this.and();
        }
    }
}

