/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenModelFactory;
import io.swagger.codegen.v3.CodegenModelType;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.ISchemaHandler;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class SchemaHandler
implements ISchemaHandler {
    public static final String ONE_OF_PREFFIX = "OneOf";
    public static final String ANY_OF_PREFFIX = "AnyOf";
    public static final String ARRAY_ITEMS_SUFFIX = "Items";
    protected DefaultCodegenConfig codegenConfig;
    private List<CodegenModel> composedModels = new ArrayList<CodegenModel>();

    public SchemaHandler(DefaultCodegenConfig codegenConfig) {
        this.codegenConfig = codegenConfig;
    }

    public void processComposedSchemas(CodegenModel codegenModel, Schema schema, Map<String, CodegenModel> allModels) {
        if (schema instanceof ComposedSchema) {
            this.processComposedSchema(codegenModel, (ComposedSchema)schema, allModels);
            return;
        }
        if (schema instanceof ArraySchema) {
            this.processArrayItemSchema(codegenModel, (ArraySchema)schema, allModels);
            return;
        }
        Map properties = schema.getProperties();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        for (String name : properties.keySet()) {
            Schema property = (Schema)properties.get(name);
            Optional<CodegenProperty> optionalCodegenProperty = codegenModel.getVars().stream().filter(codegenProperty -> codegenProperty.baseName.equals(name)).findFirst();
            if (!optionalCodegenProperty.isPresent()) continue;
            CodegenProperty codegenProperty2 = optionalCodegenProperty.get();
            String codegenName = codegenModel.getName() + this.codegenConfig.toModelName(codegenProperty2.getName());
            if (property instanceof ComposedSchema) {
                this.processComposedSchema(codegenName, codegenProperty2, (ComposedSchema)property, allModels);
                continue;
            }
            if (!(property instanceof ArraySchema)) continue;
            this.processArrayItemSchema(codegenName, codegenProperty2, (ArraySchema)property, allModels);
        }
    }

    public List<CodegenModel> getModels() {
        return this.composedModels;
    }

    protected void processComposedSchema(CodegenModel codegenModel, ComposedSchema composedSchema, Map<String, CodegenModel> allModels) {
        List schemas = composedSchema.getOneOf();
        CodegenModel composedModel = this.createComposedModel(ONE_OF_PREFFIX + codegenModel.getName(), schemas);
        if (composedModel == null) {
            schemas = composedSchema.getAnyOf();
            composedModel = this.createComposedModel(ANY_OF_PREFFIX + codegenModel.getName(), schemas);
            if (composedModel == null) {
                return;
            }
        }
        this.addInterfaceModel(codegenModel, composedModel);
        this.addInterfaces(schemas, composedModel, allModels);
        this.composedModels.add(composedModel);
    }

    protected void processComposedSchema(String codegenModelName, CodegenProperty codegenProperty, ComposedSchema composedSchema, Map<String, CodegenModel> allModels) {
        List schemas = composedSchema.getOneOf();
        CodegenModel composedModel = this.createComposedModel(ONE_OF_PREFFIX + codegenModelName, schemas);
        if (composedModel == null) {
            schemas = composedSchema.getAnyOf();
            composedModel = this.createComposedModel(ANY_OF_PREFFIX + codegenModelName, schemas);
            if (composedModel == null) {
                return;
            }
        }
        this.addInterfaces(schemas, composedModel, allModels);
        codegenProperty.datatype = composedModel.getName();
        codegenProperty.datatypeWithEnum = composedModel.getName();
        codegenProperty.baseType = composedModel.getName();
        codegenProperty.complexType = composedModel.getName();
        this.composedModels.add(composedModel);
    }

    protected void processArrayItemSchema(CodegenModel codegenModel, ArraySchema arraySchema, Map<String, CodegenModel> allModels) {
        Schema itemsSchema = arraySchema.getItems();
        if (itemsSchema instanceof ComposedSchema) {
            CodegenModel itemsModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
            itemsModel.setName(codegenModel.name + ARRAY_ITEMS_SUFFIX);
            this.processComposedSchema(itemsModel, (ComposedSchema)itemsSchema, allModels);
        }
    }

    protected void processArrayItemSchema(String codegenModelName, CodegenProperty codegenProperty, ArraySchema arraySchema, Map<String, CodegenModel> allModels) {
        Schema itemsSchema = arraySchema.getItems();
        if (itemsSchema instanceof ComposedSchema) {
            this.processComposedSchema(codegenModelName, codegenProperty, (ComposedSchema)itemsSchema, allModels);
        }
    }

    protected CodegenModel createComposedModel(String name, List<Schema> schemas) {
        if (schemas == null || schemas.isEmpty()) {
            return null;
        }
        CodegenModel composedModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        composedModel.setIsComposedModel(true);
        composedModel.setInterfaces(new ArrayList());
        this.configureModel(composedModel, name);
        return composedModel;
    }

    protected void addInterfaceModel(CodegenModel codegenModel, CodegenModel interfaceModel) {
        if (codegenModel == null) {
            return;
        }
        if (codegenModel.getInterfaceModels() == null) {
            codegenModel.setInterfaceModels(new ArrayList());
        }
        codegenModel.getInterfaceModels().add(interfaceModel);
    }

    protected void addInterfaces(List<Schema> schemas, CodegenModel codegenModel, Map<String, CodegenModel> allModels) {
        for (Schema interfaceSchema : schemas) {
            String ref = interfaceSchema.get$ref();
            if (StringUtils.isBlank((CharSequence)ref)) continue;
            String schemaName = ref.substring(ref.lastIndexOf("/") + 1);
            this.addInterfaceModel(allModels.get(this.codegenConfig.toModelName(schemaName)), codegenModel);
        }
    }

    protected void configureModel(CodegenModel codegenModel, String name) {
        codegenModel.name = name;
        codegenModel.classname = this.codegenConfig.toModelName(name);
        codegenModel.classVarName = this.codegenConfig.toVarName(name);
        codegenModel.classFilename = this.codegenConfig.toModelFilename(name);
    }

    protected boolean hasNonObjectSchema(List<Schema> schemas) {
        for (Schema schema : schemas) {
            if (this.codegenConfig.isObjectSchema(schema)) continue;
            return true;
        }
        return false;
    }
}

