/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.features.BeanValidationFeatures;
import io.swagger.codegen.v3.generators.features.JbossFeature;
import io.swagger.codegen.v3.generators.features.SwaggerFeatures;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.java.AbstractJavaJAXRSServerCodegen;
import io.swagger.v3.oas.models.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class JavaResteasyEapServerCodegen
extends AbstractJavaJAXRSServerCodegen
implements JbossFeature,
BeanValidationFeatures,
SwaggerFeatures {
    protected boolean generateJbossDeploymentDescriptor = true;
    protected boolean useSwaggerFeature = false;

    public JavaResteasyEapServerCodegen() {
        this.useBeanValidation = true;
        this.artifactId = "swagger-jaxrs-resteasy-eap-server";
        this.outputFolder = "generated-code/JavaJaxRS-Resteasy-eap";
        this.dateLibrary = "legacy";
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations"));
        this.cliOptions.add(CliOption.newBoolean((String)"generateJbossDeploymentDescriptor", (String)"Generate Jboss Deployment Descriptor"));
        this.cliOptions.add(CliOption.newBoolean((String)"useSwaggerFeature", (String)"Use dynamic Swagger generator"));
    }

    public String getName() {
        return "jaxrs-resteasy-eap";
    }

    public String getHelp() {
        return "[WORK IN PROGRESS: generated code depends from Swagger v2 libraries] Generates a Java JAXRS-Resteasy Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isBlank((CharSequence)this.templateDir)) {
            this.embeddedTemplateDir = this.templateDir = this.getTemplateDir();
        }
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        if (this.additionalProperties.containsKey("generateJbossDeploymentDescriptor")) {
            boolean generateJbossDeploymentDescriptorProp = this.convertPropertyToBooleanAndWriteBack("generateJbossDeploymentDescriptor");
            this.setGenerateJbossDeploymentDescriptor(generateJbossDeploymentDescriptorProp);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        if (this.useBeanValidation) {
            this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        }
        if (this.additionalProperties.containsKey("useSwaggerFeature")) {
            this.setUseSwaggerFeature(this.convertPropertyToBoolean("useSwaggerFeature"));
        }
        if (this.useSwaggerFeature) {
            this.writePropertyBack("useSwaggerFeature", this.useSwaggerFeature);
        }
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("gradle.mustache", "", "build.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("settingsGradle.mustache", "", "settings.gradle"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.supportingFiles.add(new SupportingFile("JacksonConfig.mustache", (this.projectFolder + File.separator + "java" + '/' + this.invokerPackage).replace(".", "/"), "JacksonConfig.java"));
        if (this.generateJbossDeploymentDescriptor) {
            this.writeOptional(this.outputFolder, new SupportingFile("jboss-web.mustache", "src/main/webapp/WEB-INF", "jboss-web.xml"));
        }
        this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.projectFolder + File.separator + "java" + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
    }

    @Override
    public String getArgumentsLocation() {
        return "";
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaJaxRS/resteasy/eap";
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return super.postProcessOperations(objs);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum");
        if (!BooleanUtils.toBoolean((Boolean)isEnum)) {
            model.imports.add("JsonProperty");
            boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-has-enums");
            if (BooleanUtils.toBoolean((Boolean)hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)cm, "x-is-enum");
            if (!Boolean.TRUE.equals(isEnum) || cm.allowableValues == null) continue;
            cm.imports.add(this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setGenerateJbossDeploymentDescriptor(boolean generateJbossDeploymentDescriptor) {
        this.generateJbossDeploymentDescriptor = generateJbossDeploymentDescriptor;
    }

    @Override
    public void setUseSwaggerFeature(boolean useSwaggerFeature) {
        this.useSwaggerFeature = useSwaggerFeature;
    }
}

