package io.swagger.v3.oas.annotations.media;

import io.swagger.v3.oas.annotations.OpenAPI31;

import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;

/**
 * The annotation may be used to define dependent schemas for an Object Schema
 *
 * @see Schema
 *
 * @since 2.2.12 / OpenAPI 3.1
 **/
@Target({FIELD, METHOD, PARAMETER, TYPE, ANNOTATION_TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Repeatable(DependentRequiredMap.class)
@OpenAPI31
public @interface DependentRequired {
    /**
     * The name.
     *
     * @return the name
     **/
    String name() default "";

    /**
     * The values of the dependent schema.
     *
     * @return the schema
     **/
    String[] value() default {};

}
