/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.jaxrs2.ResolvedParameter;
import io.swagger.v3.jaxrs2.ext.AbstractOpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;

public class DefaultParameterExtension
extends AbstractOpenAPIExtension {
    private static String QUERY_PARAM = "query";
    private static String HEADER_PARAM = "header";
    private static String COOKIE_PARAM = "cookie";
    private static String PATH_PARAM = "path";
    private static String FORM_PARAM = "form";
    final ObjectMapper mapper = Json.mapper();

    @Override
    public ResolvedParameter extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Components components, Consumes classConsumes, Consumes methodConsumes, boolean includeRequestBody, JsonView jsonViewAnnotation, Iterator<OpenAPIExtension> chain) {
        io.swagger.v3.oas.models.parameters.Parameter unknownParameter;
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ResolvedParameter();
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> parameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        io.swagger.v3.oas.models.parameters.Parameter parameter = null;
        ResolvedParameter extractParametersResult = new ResolvedParameter();
        for (Annotation annotation : annotations) {
            io.swagger.v3.oas.models.parameters.Parameter pp;
            QueryParam param;
            if (annotation instanceof QueryParam) {
                param = (QueryParam)annotation;
                io.swagger.v3.oas.models.parameters.Parameter qp = new io.swagger.v3.oas.models.parameters.Parameter();
                qp.setIn(QUERY_PARAM);
                qp.setName(param.value());
                parameter = qp;
                continue;
            }
            if (annotation instanceof PathParam) {
                param = (PathParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(PATH_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof MatrixParam) {
                param = (MatrixParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(PATH_PARAM);
                pp.setStyle(Parameter.StyleEnum.MATRIX);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof HeaderParam) {
                param = (HeaderParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(HEADER_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof CookieParam) {
                param = (CookieParam)annotation;
                pp = new io.swagger.v3.oas.models.parameters.Parameter();
                pp.setIn(COOKIE_PARAM);
                pp.setName(param.value());
                parameter = pp;
                continue;
            }
            if (annotation instanceof Parameter) {
                io.swagger.v3.oas.models.parameters.Parameter pp2;
                if (((Parameter)annotation).hidden()) {
                    extractParametersResult.parameters = parameters;
                    return extractParametersResult;
                }
                if (parameter != null) continue;
                parameter = pp2 = new io.swagger.v3.oas.models.parameters.Parameter();
                continue;
            }
            if (!this.handleAdditionalAnnotation(parameters, annotation, type, typesToSkip, classConsumes, methodConsumes, components, includeRequestBody, jsonViewAnnotation)) continue;
            extractParametersResult.parameters.addAll(parameters);
            return extractParametersResult;
        }
        if (parameter != null && StringUtils.isNotBlank((CharSequence)parameter.getIn())) {
            parameters.add(parameter);
        } else if (includeRequestBody && (unknownParameter = ParameterProcessor.applyAnnotations(null, (Type)type, annotations, (Components)components, (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), (JsonView)jsonViewAnnotation)) != null) {
            if (StringUtils.isNotBlank((CharSequence)unknownParameter.getIn()) && !"form".equals(unknownParameter.getIn())) {
                extractParametersResult.parameters.add(unknownParameter);
            } else if ("form".equals(unknownParameter.getIn())) {
                unknownParameter.setIn(null);
                extractParametersResult.formParameter = unknownParameter;
            } else {
                extractParametersResult.requestBody = unknownParameter;
            }
        }
        for (io.swagger.v3.oas.models.parameters.Parameter p : parameters) {
            io.swagger.v3.oas.models.parameters.Parameter processedParameter = ParameterProcessor.applyAnnotations((io.swagger.v3.oas.models.parameters.Parameter)p, (Type)type, annotations, (Components)components, (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), (JsonView)jsonViewAnnotation);
            if (processedParameter == null) continue;
            extractParametersResult.parameters.add(processedParameter);
        }
        return extractParametersResult;
    }

    private boolean handleAdditionalAnnotation(List<io.swagger.v3.oas.models.parameters.Parameter> parameters, Annotation annotation, Type type, Set<Type> typesToSkip, Consumes classConsumes, Consumes methodConsumes, Components components, boolean includeRequestBody, JsonView jsonViewAnnotation) {
        boolean processed = false;
        if (BeanParam.class.isAssignableFrom(annotation.getClass())) {
            BeanDescription beanDesc = this.mapper.getSerializationConfig().introspect(this.constructType(type));
            List properties = beanDesc.findProperties();
            for (BeanPropertyDefinition propDef : properties) {
                AnnotatedField field = propDef.getField();
                AnnotatedMethod setter = propDef.getSetter();
                AnnotatedMethod getter = propDef.getGetter();
                ArrayList<Annotation> paramAnnotations = new ArrayList<Annotation>();
                Iterator<OpenAPIExtension> extensions = OpenAPIExtensions.chain();
                JavaType paramType = null;
                if (field != null) {
                    paramType = field.getType();
                    for (Annotation fieldAnnotation : field.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (setter != null) {
                    if (paramType == null) {
                        paramType = setter.getParameterType(0);
                    }
                    for (Annotation fieldAnnotation : setter.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (getter != null) {
                    if (paramType == null) {
                        paramType = getter.getType();
                    }
                    for (Annotation fieldAnnotation : getter.annotations()) {
                        if (paramAnnotations.contains(fieldAnnotation)) continue;
                        paramAnnotations.add(fieldAnnotation);
                    }
                }
                if (paramType == null) continue;
                List<io.swagger.v3.oas.models.parameters.Parameter> extracted = extensions.next().extractParameters(paramAnnotations, (Type)paramType, typesToSkip, (Components)components, (Consumes)classConsumes, (Consumes)methodConsumes, (boolean)includeRequestBody, (JsonView)jsonViewAnnotation, extensions).parameters;
                for (io.swagger.v3.oas.models.parameters.Parameter p : extracted) {
                    io.swagger.v3.oas.models.parameters.Parameter processedParam = ParameterProcessor.applyAnnotations((io.swagger.v3.oas.models.parameters.Parameter)p, (Type)paramType, paramAnnotations, (Components)components, (String[])(classConsumes == null ? new String[]{} : classConsumes.value()), (String[])(methodConsumes == null ? new String[]{} : methodConsumes.value()), (JsonView)jsonViewAnnotation);
                    if (processedParam == null) continue;
                    parameters.add(processedParam);
                }
                processed = true;
            }
        }
        return processed;
    }

    @Override
    protected boolean shouldIgnoreClass(Class<?> cls) {
        return cls.getName().startsWith("javax.ws.rs.");
    }
}

