/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.processors;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.parser.ResolverCache;
import io.swagger.v3.parser.processors.CallbackProcessor;
import io.swagger.v3.parser.processors.ExampleProcessor;
import io.swagger.v3.parser.processors.HeaderProcessor;
import io.swagger.v3.parser.processors.LinkProcessor;
import io.swagger.v3.parser.processors.ParameterProcessor;
import io.swagger.v3.parser.processors.RequestBodyProcessor;
import io.swagger.v3.parser.processors.ResponseProcessor;
import io.swagger.v3.parser.processors.SchemaProcessor;
import io.swagger.v3.parser.processors.SecuritySchemeProcessor;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ComponentsProcessor {
    private final ResolverCache cache;
    private final OpenAPI openApi;
    private final SchemaProcessor schemaProcessor;
    private final ResponseProcessor responseProcessor;
    private final RequestBodyProcessor requestBodyProcessor;
    private final ParameterProcessor parameterProcessor;
    private final HeaderProcessor headerProcessor;
    private final ExampleProcessor exampleProcessor;
    private final LinkProcessor linkProcessor;
    private final CallbackProcessor callbackProcessor;
    private final SecuritySchemeProcessor securitySchemeProcessor;

    public ComponentsProcessor(OpenAPI openApi, ResolverCache cache) {
        this(openApi, cache, false);
    }

    public ComponentsProcessor(OpenAPI openApi, ResolverCache cache, boolean openapi31) {
        this.cache = cache;
        this.openApi = openApi;
        this.schemaProcessor = new SchemaProcessor(cache, openApi, openapi31);
        this.responseProcessor = new ResponseProcessor(cache, openApi, openapi31);
        this.requestBodyProcessor = new RequestBodyProcessor(cache, openApi, openapi31);
        this.parameterProcessor = new ParameterProcessor(cache, openApi, openapi31);
        this.headerProcessor = new HeaderProcessor(cache, openApi, openapi31);
        this.exampleProcessor = new ExampleProcessor(cache, openApi);
        this.linkProcessor = new LinkProcessor(cache, openApi, openapi31);
        this.callbackProcessor = new CallbackProcessor(cache, openApi, openapi31);
        this.securitySchemeProcessor = new SecuritySchemeProcessor(cache, openApi);
    }

    public void processComponents() {
        Map schemas;
        LinkedHashSet<String> keySet;
        if (this.openApi.getComponents() == null) {
            return;
        }
        Map responses = this.openApi.getComponents().getResponses();
        Map requestBodies = this.openApi.getComponents().getRequestBodies();
        Map parameters = this.openApi.getComponents().getParameters();
        Map headers = this.openApi.getComponents().getHeaders();
        Map examples = this.openApi.getComponents().getExamples();
        Map links = this.openApi.getComponents().getLinks();
        Map callbacks = this.openApi.getComponents().getCallbacks();
        Map securitySchemes = this.openApi.getComponents().getSecuritySchemes();
        if (responses != null) {
            keySet = new LinkedHashSet<String>();
            while (responses.keySet().size() > keySet.size()) {
                this.processResponses(keySet, responses);
            }
        }
        if (requestBodies != null) {
            keySet = new LinkedHashSet();
            while (requestBodies.keySet().size() > keySet.size()) {
                this.processRequestBodies(keySet, requestBodies);
            }
        }
        if (parameters != null) {
            keySet = new LinkedHashSet();
            while (parameters.keySet().size() > keySet.size()) {
                this.processParameters(keySet, parameters);
            }
        }
        if (headers != null) {
            keySet = new LinkedHashSet();
            while (headers.keySet().size() > keySet.size()) {
                this.processHeaders(keySet, headers);
            }
        }
        if (examples != null) {
            keySet = new LinkedHashSet();
            while (examples.keySet().size() > keySet.size()) {
                this.processExamples(keySet, examples);
            }
        }
        if (links != null) {
            keySet = new LinkedHashSet();
            while (links.keySet().size() > keySet.size()) {
                this.processLinks(keySet, links);
            }
        }
        if (callbacks != null) {
            keySet = new LinkedHashSet();
            while (callbacks.keySet().size() > keySet.size()) {
                this.processCallbacks(keySet, callbacks);
            }
        }
        if (securitySchemes != null) {
            keySet = new LinkedHashSet();
            while (securitySchemes.keySet().size() > keySet.size()) {
                this.processSecuritySchemes(keySet, securitySchemes);
            }
        }
        if ((schemas = this.openApi.getComponents().getSchemas()) != null) {
            LinkedHashSet<String> keySet2 = new LinkedHashSet<String>();
            while (schemas.keySet().size() > keySet2.size()) {
                this.processSchemas(keySet2, schemas);
            }
        }
    }

    private void processSecuritySchemes(Set<String> securitySchemeKey, Map<String, SecurityScheme> securitySchemes) {
        securitySchemeKey.addAll(securitySchemes.keySet());
        for (String securitySchemeName : securitySchemeKey) {
            SecurityScheme securityScheme = securitySchemes.get(securitySchemeName);
            SecurityScheme resolvedSecurityScheme = this.securitySchemeProcessor.processSecurityScheme(securityScheme);
            securitySchemes.replace(securitySchemeName, securityScheme, resolvedSecurityScheme);
        }
    }

    private void processCallbacks(Set<String> callbackKey, Map<String, Callback> callbacks) {
        callbackKey.addAll(callbacks.keySet());
        for (String callbackName : callbackKey) {
            Callback callback = callbacks.get(callbackName);
            this.callbackProcessor.processCallback(callback);
        }
    }

    private void processLinks(Set<String> linkKey, Map<String, Link> links) {
        linkKey.addAll(links.keySet());
        for (String linkName : linkKey) {
            Link link = links.get(linkName);
            this.linkProcessor.processLink(link);
        }
    }

    private void processExamples(Set<String> exampleKey, Map<String, Example> examples) {
        exampleKey.addAll(examples.keySet());
        for (String exampleName : exampleKey) {
            Example example = examples.get(exampleName);
            this.exampleProcessor.processExample(example);
        }
    }

    private void processHeaders(Set<String> HeaderKey, Map<String, Header> headers) {
        HeaderKey.addAll(headers.keySet());
        for (String headersName : HeaderKey) {
            Header header = headers.get(headersName);
            this.headerProcessor.processHeader(header);
        }
    }

    private void processParameters(Set<String> ParametersKey, Map<String, Parameter> parameters) {
        ParametersKey.addAll(parameters.keySet());
        for (String parametersName : ParametersKey) {
            Parameter parameter = parameters.get(parametersName);
            this.parameterProcessor.processParameter(parameter);
        }
    }

    private void processRequestBodies(Set<String> requestBodyKey, Map<String, RequestBody> requestBodies) {
        requestBodyKey.addAll(requestBodies.keySet());
        for (String requestBodyName : requestBodyKey) {
            RequestBody requestBody = requestBodies.get(requestBodyName);
            this.requestBodyProcessor.processRequestBody(requestBody);
        }
    }

    private void processResponses(Set<String> responseKey, Map<String, ApiResponse> responses) {
        responseKey.addAll(responses.keySet());
        for (String responseName : responseKey) {
            ApiResponse response = responses.get(responseName);
            this.responseProcessor.processResponse(response);
        }
    }

    public void processSchemas(Set<String> schemaKeys, Map<String, Schema> schemas) {
        Schema model;
        schemaKeys.addAll(schemas.keySet());
        for (String modelName : schemaKeys) {
            String renamedRef;
            model = schemas.get(modelName);
            String originalRef = model.get$ref() != null ? model.get$ref() : null;
            this.schemaProcessor.processSchema(model);
            if (model.get$ref() == null || (renamedRef = this.cache.getRenamedRef(originalRef)) == null) continue;
            Schema resolvedModel = schemas.get(renamedRef);
            if (!this.cache.hasReferencedKey(renamedRef)) {
                schemas.remove(renamedRef);
            }
            schemas.put(modelName, resolvedModel);
        }
        for (String modelName : schemaKeys) {
            model = schemas.get(modelName);
            Map properties = model.getProperties();
            if (properties == null) continue;
            for (Map.Entry propertyEntry : properties.entrySet()) {
                Schema property = (Schema)propertyEntry.getValue();
                if (property.get$ref() == null) continue;
                this.schemaProcessor.processSchema(model);
            }
        }
    }
}

