/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaJAXRSServerCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class JavaJAXRSSpecServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    public JavaJAXRSSpecServerCodegen() {
        this.invokerPackage = "io.swagger.api";
        this.artifactId = "swagger-jaxrs-server";
        this.outputFolder = "generated-code/JavaJaxRS-Spec";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiPackage = "io.swagger.api";
        this.modelPackage = "io.swagger.model";
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.additionalProperties.put("title", this.title);
        this.typeMapping.put("date", "LocalDate");
        this.typeMapping.put("DateTime", "javax.xml.datatype.XMLGregorianCalendar");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "spec";
        for (int i = 0; i < this.cliOptions.size(); ++i) {
            if (!"library".equals(((CliOption)this.cliOptions.get(i)).getOpt())) continue;
            this.cliOptions.remove(i);
            break;
        }
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setDefault("<default>");
        LinkedHashMap<String, String> supportedLibraries = new LinkedHashMap<String, String>();
        supportedLibraries.put("<default>", "JAXRS");
        library.setEnum(supportedLibraries);
        this.cliOptions.add(library);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("RestApplication.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "RestApplication.java"));
    }

    @Override
    public String getName() {
        return "jaxrs-spec";
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("ApiModelProperty");
        model.imports.remove("ApiModel");
        model.imports.remove("JsonSerialize");
        model.imports.remove("ToStringSerializer");
        model.imports.remove("JsonValue");
        model.imports.remove("JsonProperty");
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        try {
            String swaggerJson = Json.pretty((Object)swagger);
            FileUtils.writeStringToFile((File)new File(this.outputFolder + File.separator + "swagger.json"), (String)swaggerJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
        super.preprocessSwagger(swagger);
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Server according to JAXRS 2.0 specification.";
    }
}

