/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractPhpCodegen;
import io.swagger.models.HttpMethod;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZendExpressivePathHandlerServerCodegen
extends AbstractPhpCodegen {
    public static final String VEN_FROM_QUERY = "internal.ze-ph.fromQuery";
    public static final String VEN_COLLECTION_FORMAT = "internal.ze-ph.collectionFormat";
    public static final String VEN_QUERY_DATA_TYPE = "internal.ze-ph.queryDataType";
    public static final String VEN_HAS_QUERY_DATA = "internal.ze-ph.hasQueryData";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "ze-ph";
    }

    @Override
    public String getHelp() {
        return "Generates PHP server stub using Zend Expressive ( https://zendframework.github.io/zend-expressive ) and Path Handler ( https://github.com/Articus/PathHandler ).";
    }

    public ZendExpressivePathHandlerServerCodegen() {
        this.typeMapping.put("double", "float");
        this.templateDir = "ze-ph";
        this.embeddedTemplateDir = "ze-ph";
        this.invokerPackage = "App";
        this.packagePath = "";
        this.srcBasePath = "src" + File.separator + "App";
        this.apiDirName = "Handler";
        this.modelDirName = "DTO";
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.apiTestTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.supportingFiles.add(new SupportingFile("README.md.mustache", this.packagePath, "README.md"));
        this.supportingFiles.add(new SupportingFile("composer.json.mustache", this.packagePath, "composer.json"));
        this.supportingFiles.add(new SupportingFile("index.php", this.packagePath + File.separator + "public", "index.php"));
        this.supportingFiles.add(new SupportingFile("container.php", this.packagePath + File.separator + "application", "container.php"));
        this.supportingFiles.add(new SupportingFile("config.yml", this.packagePath + File.separator + "application", "config.yml"));
        this.supportingFiles.add(new SupportingFile("app.yml.mustache", this.packagePath + File.separator + "application" + File.separator + "config", "app.yml"));
        this.supportingFiles.add(new SupportingFile("path_handler.yml.mustache", this.packagePath + File.separator + "application" + File.separator + "config", "path_handler.yml"));
        this.supportingFiles.add(new SupportingFile("data_transfer.yml.mustache", this.packagePath + File.separator + "application" + File.separator + "config", "data_transfer.yml"));
        this.supportingFiles.add(new SupportingFile("ErrorMiddleware.php.mustache", this.packagePath + File.separator + this.srcBasePath, "ErrorMiddleware.php"));
        this.supportingFiles.add(new SupportingFile("Date.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Strategy", "Date.php"));
        this.supportingFiles.add(new SupportingFile("DateTime.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Strategy", "DateTime.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameter.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Strategy", "QueryParameter.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameterArray.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Strategy", "QueryParameterArray.php"));
        this.supportingFiles.add(new SupportingFile("Type.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Validator", "Type.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameterType.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Validator", "QueryParameterType.php"));
        this.supportingFiles.add(new SupportingFile("QueryParameterArrayType.php.mustache", this.packagePath + File.separator + this.srcBasePath + File.separator + "Validator", "QueryParameterArrayType.php"));
        this.additionalProperties.put("artifactVersion", "1.0.0");
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(resourcePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(resourcePath, opList);
        }
        int counter = 0;
        for (CodegenOperation op : opList) {
            if (!co.operationId.equals(op.operationId)) continue;
            ++counter;
        }
        if (counter == 0) {
            co.operationIdLowerCase = co.operationId.toLowerCase();
            opList.add(co);
            co.baseName = tag;
        }
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        name = name.replaceAll("[\\}]", "");
        return super.toModelName(name);
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        super.preprocessSwagger(swagger);
        for (String pathKey : swagger.getPaths().keySet()) {
            Path path = swagger.getPath(pathKey);
            Map operations = path.getOperationMap();
            for (HttpMethod method : operations.keySet()) {
                Operation operation = (Operation)operations.get(method);
                HashMap<String, Property> properties = new HashMap<String, Property>();
                for (Parameter parameter : operation.getParameters()) {
                    Property property = this.convertParameterToProperty(parameter);
                    if (property == null) continue;
                    properties.put(property.getName(), property);
                }
                if (properties.isEmpty()) continue;
                ModelImpl model = new ModelImpl();
                String operationId = this.getOrGenerateOperationId(operation, pathKey, method.name());
                model.setDescription("Query parameters for " + operationId);
                model.setProperties(properties);
                model.getVendorExtensions().put(VEN_FROM_QUERY, Boolean.TRUE);
                String definitionName = this.generateUniqueDefinitionName(operationId + "QueryData", swagger);
                swagger.addDefinition(definitionName, (Model)model);
                String definitionModel = "\\" + this.modelPackage + "\\" + this.toModelName(definitionName);
                operation.getVendorExtensions().put(VEN_QUERY_DATA_TYPE, definitionModel);
                operation.getVendorExtensions().put(VEN_HAS_QUERY_DATA, Boolean.TRUE);
            }
        }
    }

    protected Property convertParameterToProperty(Parameter parameter) {
        BooleanProperty property = null;
        if (parameter instanceof QueryParameter) {
            QueryParameter queryParameter = (QueryParameter)parameter;
            switch (queryParameter.getType()) {
                case "string": {
                    StringProperty stringProperty = new StringProperty();
                    stringProperty.setMinLength(queryParameter.getMinLength());
                    stringProperty.setMaxLength(queryParameter.getMaxLength());
                    stringProperty.setPattern(queryParameter.getPattern());
                    stringProperty.setEnum(queryParameter.getEnum());
                    property = stringProperty;
                    break;
                }
                case "integer": {
                    IntegerProperty integerProperty = new IntegerProperty();
                    integerProperty.setMinimum(queryParameter.getMinimum());
                    integerProperty.setMaximum(queryParameter.getMaximum());
                    property = integerProperty;
                    break;
                }
                case "number": {
                    FloatProperty floatProperty = new FloatProperty();
                    floatProperty.setMinimum(queryParameter.getMinimum());
                    floatProperty.setMaximum(queryParameter.getMaximum());
                    property = floatProperty;
                    break;
                }
                case "boolean": {
                    property = new BooleanProperty();
                    break;
                }
                case "array": {
                    ArrayProperty arrayProperty = new ArrayProperty();
                    arrayProperty.setMinItems(queryParameter.getMinItems());
                    arrayProperty.setMaxItems(queryParameter.getMaxItems());
                    arrayProperty.setItems(queryParameter.getItems());
                    String collectionFormat = queryParameter.getCollectionFormat();
                    if (collectionFormat == null) {
                        collectionFormat = "csv";
                    }
                    arrayProperty.getVendorExtensions().put(VEN_COLLECTION_FORMAT, collectionFormat);
                    property = arrayProperty;
                    break;
                }
                case "date": {
                    property = new DateProperty();
                    break;
                }
                case "date-time": {
                    property = new DateTimeProperty();
                }
            }
            if (property != null) {
                property.setName(queryParameter.getName());
                property.setDescription(queryParameter.getDescription());
                property.setRequired(queryParameter.getRequired());
                property.getVendorExtensions().put(VEN_FROM_QUERY, Boolean.TRUE);
            }
        }
        return property;
    }

    protected String generateUniqueDefinitionName(String name, Swagger swagger) {
        String result = name;
        if (swagger.getDefinitions() != null) {
            int count = 1;
            while (swagger.getDefinitions().containsKey(result)) {
                result = name + "_" + count;
                ++count;
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        objs = super.postProcessOperations(objs);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        StringBuilder interfacesToImplement = new StringBuilder();
        String pathPattern = null;
        for (CodegenOperation op : operationList) {
            String classMethod;
            String interfaceToImplement;
            switch (op.httpMethod) {
                case "GET": {
                    interfaceToImplement = "Operation\\GetInterface";
                    classMethod = "handleGet";
                    break;
                }
                case "POST": {
                    interfaceToImplement = "Operation\\PostInterface";
                    classMethod = "handlePost";
                    break;
                }
                case "PATCH": {
                    interfaceToImplement = "Operation\\PatchInterface";
                    classMethod = "handlePatch";
                    break;
                }
                case "PUT": {
                    interfaceToImplement = "Operation\\PutInterface";
                    classMethod = "handlePut";
                    break;
                }
                case "DELETE": {
                    interfaceToImplement = "Operation\\DeleteInterface";
                    classMethod = "handleDelete";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown HTTP Method " + op.httpMethod + " not allowed");
                }
            }
            if (interfacesToImplement.length() > 0) {
                interfacesToImplement.append(", ");
            }
            interfacesToImplement.append(interfaceToImplement);
            op.httpMethod = classMethod;
            if (pathPattern != null) continue;
            pathPattern = this.generatePathPattern(op);
        }
        operations.put("interfacesToImplement", interfacesToImplement.toString());
        operations.put("pathPattern", pathPattern);
        return objs;
    }

    protected String generatePathPattern(CodegenOperation op) {
        String result = op.path;
        for (CodegenParameter pp : op.pathParams) {
            StringBuilder replacement = new StringBuilder("{" + pp.paramName);
            if (pp.isEnum) {
                StringBuilder enumRegExp = new StringBuilder();
                for (String enumValue : pp._enum) {
                    if (enumRegExp.length() > 0) {
                        enumRegExp.append("|");
                    }
                    enumRegExp.append(enumValue.replaceAll("[\\Q<>()[]{}|^$-=!?*+.\\\\E]", "\\\\$0"));
                }
                replacement.append(":");
                replacement.append((CharSequence)enumRegExp);
            } else if (pp.isInteger) {
                replacement.append(":0|(?:-?[1-9][0-9]*)");
            } else if (pp.isString && pp.pattern != null && !pp.pattern.isEmpty()) {
                replacement.append(":");
                replacement.append(pp.pattern);
            }
            replacement.append("}");
            result = result.replace("{" + pp.paramName + "}", replacement);
        }
        return result;
    }
}

