/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.utils;

import io.swagger.oas.inflector.Constants;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Map;

public class VendorSpecFilter
extends SpecFilter {
    public Map<String, Schema> filterComponentsSchema(OpenAPISpecFilter filter, Map<String, Schema> definitions, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Map filteredDefinitions = super.filterComponentsSchema(filter, definitions, params, cookies, headers);
        if (filteredDefinitions != null) {
            for (Schema model : filteredDefinitions.values()) {
                if (model == null || model.getExtensions() == null) continue;
                this.filterVendorExtensions(model.getExtensions());
            }
        }
        return filteredDefinitions;
    }

    public Operation filterOperation(OpenAPISpecFilter filter, Operation op, String path, String key, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
        Operation operation = super.filterOperation(filter, op, path, key, params, cookies, headers);
        if (operation != null && operation.getExtensions() != null) {
            this.filterVendorExtensions(operation.getExtensions());
        }
        return operation;
    }

    private void filterVendorExtensions(Map<String, Object> vendorExtensions) {
        for (Constants.VendorExtension vendorExtension : Constants.VendorExtension.values()) {
            vendorExtensions.remove(vendorExtension.getValue());
        }
    }
}

