/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.pathmatcher;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathNormalizer {
    static final char SEPARATOR_CHAR = '/';
    private static final boolean FIXFS = File.separatorChar != '/';
    static final String SEPARATOR = "/";
    private final String basedir;

    private PathNormalizer(String basedir) {
        this.basedir = basedir;
    }

    public static PathNormalizer createNormalizer(Path basedir) {
        return new PathNormalizer(PathNormalizer.toCanonicalPath(basedir));
    }

    public static PathNormalizer createNormalizer(String memento) {
        return new PathNormalizer(memento);
    }

    public static PathNormalizer createNormalizer() {
        return new PathNormalizer(null);
    }

    public String getMemento() {
        if (this.basedir == null) {
            throw new IllegalStateException();
        }
        return this.basedir;
    }

    public String normalize(String file) {
        if (this.isBasedirOrNestedFile(file)) {
            return FIXFS ? PathNormalizer.fixfs(file) : file;
        }
        return PathNormalizer.normalize0(file);
    }

    private static String fixfs(String file) {
        return String.valueOf('/') + file.replace(File.separatorChar, '/');
    }

    boolean isBasedirOrNestedFile(String file) {
        if (this.basedir != null && file.startsWith(this.basedir)) {
            int baseLength = this.basedir.length();
            if (baseLength == file.length()) {
                return true;
            }
            char charL = file.charAt(baseLength);
            return charL == '/' || charL == File.separatorChar;
        }
        return false;
    }

    public String normalize(Path path) {
        String file = path.toString();
        if (this.isBasedirOrNestedFile(file)) {
            return FIXFS ? PathNormalizer.fixfs(file) : file;
        }
        return PathNormalizer.normalize0(path);
    }

    public static String normalize0(Path file) {
        String canonicalPath = PathNormalizer.toCanonicalPath(file);
        if (FIXFS) {
            return PathNormalizer.fixfs(canonicalPath);
        }
        return canonicalPath;
    }

    private static String toCanonicalPath(Path file) {
        try {
            return file.toFile().getCanonicalPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path getCanonicalPath(Path file) {
        try {
            return file.toFile().getCanonicalFile().toPath();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String normalize0(String file) {
        return PathNormalizer.normalize0(PathNormalizer.toPath(file));
    }

    public static Path toPath(String file) {
        if (FIXFS) {
            return new File(file).toPath();
        }
        return Paths.get(file, new String[0]);
    }
}

