/*
 * Decompiled with CFR 0.152.
 */
package io.takari.graph.dot;

import io.takari.graph.dot.Point;

public class Spline {
    Point startingPoint = null;
    Point endingPoint = null;
    private Point[] controls;

    public void addControls(Point point) {
        if (this.controls == null) {
            this.controls = new Point[1];
            this.controls[0] = point;
        } else {
            Point[] tmp = new Point[this.controls.length + 1];
            System.arraycopy(this.controls, 0, tmp, 0, this.controls.length);
            tmp[tmp.length - 1] = point;
            this.controls = tmp;
        }
    }

    public Point[] getControls() {
        return this.controls;
    }

    public String toString() {
        String s = "";
        s = s + this.printPoint("e", this.endingPoint);
        s = s + this.printPoint("s", this.startingPoint);
        s = s + this.printControls();
        return s;
    }

    private String printPoint(String control, Point point) {
        String o = "";
        if (point != null) {
            for (int i = 0; i < point.coords.length; ++i) {
                if (i > 0 && i < point.coords.length) {
                    o = o + ",";
                }
                o = o + point.coords[i];
                if (i != point.coords.length - 1) continue;
                o = o + (point.change ? "" : "!");
            }
            return control + "," + o + " ";
        }
        return "";
    }

    private String printControls() {
        String o = "";
        for (int i = 0; i < this.controls.length; ++i) {
            if (i > 0 && i < this.controls.length) {
                o = o + " ";
            }
            Point p = this.controls[i];
            for (int j = 0; j < p.coords.length; ++j) {
                if (j > 0 && j < p.coords.length) {
                    o = o + ",";
                }
                o = o + p.coords[j];
                if (j != p.coords.length - 1) continue;
                o = o + (p.change ? "" : "!");
            }
        }
        return o;
    }
}

