/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile;

import io.takari.maven.plugins.compile.ArtifactFile;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@MojoExecutionScoped
public class ProjectClasspathDigester {
    private static final String ATTR_CLASSPATH_DIGEST = "compile.classpath.digest";
    private static final String ATTR_SOURCEPATH_DIGEST = "compile.sourcepath.digest";
    private static final String ATTR_PROCESSORPATH_DIGEST = "compile.processorpath.digest";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Map<File, ArtifactFile> CACHE = new ConcurrentHashMap<File, ArtifactFile>();
    private final CompilerBuildContext context;

    @Inject
    public ProjectClasspathDigester(CompilerBuildContext context) {
        this.context = context;
    }

    public boolean digestClasspath(List<File> dependencies) throws IOException {
        return this.digest(ATTR_CLASSPATH_DIGEST, dependencies);
    }

    public boolean digestSourcepath(List<File> dependencies) throws IOException {
        return this.digest(ATTR_SOURCEPATH_DIGEST, dependencies);
    }

    public boolean digestProcessorpath(List<File> dependencies) throws IOException {
        return this.digest(ATTR_PROCESSORPATH_DIGEST, dependencies);
    }

    private boolean digest(String key, List<File> dependencies) {
        long started = System.currentTimeMillis();
        Map<File, ArtifactFile> previousArtifacts = this.getPreviousDependencies(key);
        LinkedHashMap<File, ArtifactFile> digest = new LinkedHashMap<File, ArtifactFile>();
        if (dependencies != null) {
            for (File dependency : dependencies) {
                File normalized = this.normalize(dependency);
                ArtifactFile previousArtifact = previousArtifacts.get(normalized);
                ArtifactFile artifact = CACHE.get(normalized);
                if (artifact == null) {
                    if (normalized.isFile()) {
                        artifact = this.newFileArtifact(normalized, previousArtifact);
                    } else {
                        if (!normalized.isDirectory()) continue;
                        artifact = this.newDirectoryArtifact(normalized, previousArtifact);
                    }
                    CACHE.put(normalized, artifact);
                }
                digest.put(normalized, artifact);
                if (this.equals(artifact, previousArtifact)) continue;
                this.log.debug("New or changed classpath entry {}", (Object)normalized);
            }
        }
        for (File reviousDependency : previousArtifacts.keySet()) {
            if (digest.containsKey(reviousDependency)) continue;
            this.log.debug("Removed classpath entry {}", (Object)reviousDependency);
        }
        boolean changed = !this.equals(digest.values(), previousArtifacts.values());
        this.context.setAttribute(key, new ArrayList(digest.values()));
        this.log.debug("Analyzed {} classpath dependencies ({} ms)", (Object)(dependencies != null ? dependencies.size() : 0), (Object)(System.currentTimeMillis() - started));
        return changed;
    }

    private File normalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    private boolean equals(Collection<ArtifactFile> a, Collection<ArtifactFile> b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<ArtifactFile> ia = a.iterator();
        Iterator<ArtifactFile> ib = b.iterator();
        while (ia.hasNext()) {
            if (this.equals(ia.next(), ib.next())) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ArtifactFile a, ArtifactFile b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.file.equals(b.file) && a.isFile == b.isFile && a.lastModified == b.lastModified && a.length == b.length;
    }

    private ArtifactFile newDirectoryArtifact(File directory, ArtifactFile previousArtifact) {
        StringBuilder msg = new StringBuilder();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(new String[]{"**/*"});
        scanner.scan();
        long maxLastModified = 0L;
        long fileCount = 0L;
        String[] stringArray = scanner.getIncludedFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(directory, path);
            long lastModified = file.lastModified();
            maxLastModified = Math.max(maxLastModified, lastModified);
            ++fileCount;
            if (previousArtifact != null && previousArtifact.lastModified < lastModified) {
                msg.append("\n   new or modfied class folder member ").append(file);
            }
            ++n2;
        }
        if (previousArtifact != null && previousArtifact.length != fileCount) {
            msg.append("\n   classfolder member count changed (new ").append(fileCount).append(" previous ").append(previousArtifact.length).append(')');
        }
        if (msg.length() > 0) {
            this.log.debug("Changed dependency class folder {}: {}", (Object)directory, (Object)msg.toString());
        }
        return new ArtifactFile(directory, false, fileCount, maxLastModified);
    }

    private ArtifactFile newFileArtifact(File file, ArtifactFile previousArtifact) {
        return new ArtifactFile(file, true, file.length(), file.lastModified());
    }

    private Map<File, ArtifactFile> getPreviousDependencies(String key) {
        LinkedHashMap<File, ArtifactFile> digest = new LinkedHashMap<File, ArtifactFile>();
        ArrayList artifacts = this.context.getAttribute(key, true, ArrayList.class);
        if (artifacts == null) {
            return Collections.emptyMap();
        }
        for (ArtifactFile artifact : artifacts) {
            digest.put(artifact.file, artifact);
        }
        return digest;
    }

    public static void flush() {
        CACHE.clear();
    }
}

