/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor;

import io.takari.maven.testing.executor.LauncherException;
import io.takari.maven.testing.executor.MavenInstallationUtils;
import io.takari.maven.testing.executor.MavenLauncher;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.plexus.classworlds.ClassWorldException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.launcher.ConfigurationParser;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

class Embedded3xLauncher
implements MavenLauncher {
    private static final Map<Key, Embedded3xLauncher> CACHE = new HashMap<Key, Embedded3xLauncher>();
    private final File mavenHome;
    private final Object classWorld;
    private final Object mavenCli;
    private final Method doMain;
    private final List<String> args;

    private Embedded3xLauncher(File mavenHome, Object classWorld, Object mavenCli, Method doMain, List<String> args) {
        this.mavenHome = mavenHome;
        this.classWorld = classWorld;
        this.mavenCli = mavenCli;
        this.doMain = doMain;
        this.args = args;
    }

    public static Embedded3xLauncher createFromMavenHome(File mavenHome, File classworldConf, List<String> extensions, List<String> args) throws LauncherException {
        if (!Embedded3xLauncher.isValidMavenHome(mavenHome)) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome);
        }
        List<URL> bootclasspath = Embedded3xLauncher.toClasspath(System.getProperty("maven.bootclasspath"));
        Properties originalProperties = Embedded3xLauncher.copy(System.getProperties());
        System.setProperty("maven.home", mavenHome.getAbsolutePath());
        try {
            Key key = new Key(mavenHome, classworldConf, bootclasspath, extensions, args);
            Embedded3xLauncher launcher = CACHE.get(key);
            if (launcher == null) {
                launcher = Embedded3xLauncher.createFromMavenHome0(mavenHome, classworldConf, bootclasspath, extensions, args);
                CACHE.put(key, launcher);
            }
            Embedded3xLauncher embedded3xLauncher = launcher;
            return embedded3xLauncher;
        }
        finally {
            System.setProperties(originalProperties);
        }
    }

    private static boolean isValidMavenHome(File mavenHome) {
        if (mavenHome == null) {
            return false;
        }
        if ("WORKSPACE".equals(mavenHome.getPath()) || "EMBEDDED".equals(mavenHome.getPath())) {
            return true;
        }
        return mavenHome.isDirectory();
    }

    private static List<URL> toClasspath(String string) throws LauncherException {
        if (string == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(string, File.pathSeparator);
        ArrayList<URL> classpath = new ArrayList<URL>();
        while (st.hasMoreTokens()) {
            try {
                classpath.add(new File(st.nextToken()).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new LauncherException("Invalid launcher classpath " + string, e);
            }
        }
        return classpath;
    }

    private static Embedded3xLauncher createFromMavenHome0(File mavenHome, File classworldConf, List<URL> bootclasspath, List<String> extensions, List<String> args) throws LauncherException {
        File configFile = MavenInstallationUtils.getClassworldsConf(mavenHome, classworldConf);
        ClassLoader bootLoader = Embedded3xLauncher.getBootLoader(mavenHome, bootclasspath);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bootLoader);
        try {
            ClassworldsConfiguration config = new ClassworldsConfiguration();
            ConfigurationParser configParser = new ConfigurationParser((ConfigurationHandler)config, System.getProperties());
            Throwable throwable = null;
            Object var11_13 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(configFile));){
                configParser.parse((InputStream)is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (extensions != null && !extensions.isEmpty()) {
                config.addEntries("plexus.core", extensions);
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            config.store(buf);
            Class<?> launcherClass = bootLoader.loadClass("org.codehaus.plexus.classworlds.launcher.Launcher");
            Object launcher = launcherClass.newInstance();
            launcherClass.getMethod("configure", InputStream.class).invoke(launcher, new ByteArrayInputStream(buf.toByteArray()));
            Object classWorld = launcherClass.getMethod("getWorld", new Class[0]).invoke(launcher, new Object[0]);
            Class cliClass = (Class)launcherClass.getMethod("getMainClass", new Class[0]).invoke(launcher, new Object[0]);
            Object mavenCli = cliClass.getConstructor(classWorld.getClass()).newInstance(classWorld);
            Method doMain = cliClass.getMethod("doMain", String[].class, String.class, PrintStream.class, PrintStream.class);
            Embedded3xLauncher embedded3xLauncher = new Embedded3xLauncher(mavenHome, classWorld, mavenCli, doMain, args);
            return embedded3xLauncher;
        }
        catch (IOException | ReflectiveOperationException | ClassWorldException | ConfigurationException e) {
            throw new LauncherException("Invalid Maven home directory " + mavenHome, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private static ClassLoader getBootLoader(File mavenHome, List<URL> classpath) {
        List<URL> urls = classpath;
        if (urls == null) {
            urls = new ArrayList<URL>();
            File bootDir = new File(mavenHome, "boot");
            Embedded3xLauncher.addUrls(urls, bootDir);
        }
        if (urls.isEmpty()) {
            throw new IllegalArgumentException("Invalid Maven home directory " + mavenHome);
        }
        URL[] ucp = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(ucp, ClassLoader.getSystemClassLoader().getParent());
    }

    private static void addUrls(List<URL> urls, File directory) {
        File[] jars = directory.listFiles();
        if (jars != null) {
            int i = 0;
            while (i < jars.length) {
                File jar = jars[i];
                if (jar.getName().endsWith(".jar")) {
                    try {
                        urls.add(jar.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw (RuntimeException)new IllegalStateException().initCause(e);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public int run(String[] cliArgs, File multiModuleProjectDirectory, File workingDirectory, File logFile) throws IOException, LauncherException {
        PrintStream out = logFile != null ? new PrintStream(new FileOutputStream(logFile)) : System.out;
        try {
            int n;
            Properties originalProperties = Embedded3xLauncher.copy(System.getProperties());
            System.setProperties(null);
            System.setProperty("maven.home", this.mavenHome.getAbsolutePath());
            System.setProperty("user.dir", workingDirectory.getAbsolutePath());
            System.setProperty("maven.multiModuleProjectDirectory", multiModuleProjectDirectory.getAbsolutePath());
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.mavenCli.getClass().getClassLoader());
            try {
                Set<String> origRealms = this.getRealmIds();
                ArrayList<String> args = new ArrayList<String>(this.args);
                args.addAll(Arrays.asList(cliArgs));
                out.format("Maven Executor implementation: %s\n", this.getClass().getName());
                out.format("Maven home: %s\n", this.mavenHome);
                out.format("Build work directory: %s\n", workingDirectory);
                out.format("Execution parameters: %s\n\n", args);
                Object result = this.doMain.invoke(this.mavenCli, args.toArray(new String[args.size()]), workingDirectory.getAbsolutePath(), out, out);
                Set<String> realms = this.getRealmIds();
                realms.removeAll(origRealms);
                for (String realmId : realms) {
                    this.disposeRealm(realmId);
                }
                n = ((Number)result).intValue();
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            catch (Throwable throwable) {
                try {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                    System.setProperties(originalProperties);
                    throw throwable;
                }
                catch (IllegalAccessException e) {
                    throw new LauncherException("Failed to run Maven: " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new LauncherException("Failed to run Maven: " + e.getMessage(), e);
                }
            }
            System.setProperties(originalProperties);
            return n;
        }
        finally {
            if (logFile != null) {
                out.close();
            }
        }
    }

    private static Properties copy(Properties properties) {
        Properties copy = new Properties();
        for (String key : properties.stringPropertyNames()) {
            copy.put(key, properties.getProperty(key));
        }
        return copy;
    }

    @Override
    public String getMavenVersion() throws LauncherException {
        try {
            String version = MavenInstallationUtils.getMavenVersion(this.mavenCli.getClass());
            if (version != null) {
                return version;
            }
        }
        catch (IOException e) {
            throw new LauncherException("Failed to read Maven version", e);
        }
        throw new LauncherException("Could not determine embedded Maven version");
    }

    private Set<String> getRealmIds() {
        HashSet<String> result = new HashSet<String>();
        try {
            Collection realms = (Collection)this.classWorld.getClass().getMethod("getRealms", new Class[0]).invoke(this.classWorld, new Object[0]);
            for (Object realm : realms) {
                String id = (String)realm.getClass().getMethod("getId", new Class[0]).invoke(realm, new Object[0]);
                result.add(id);
            }
        }
        catch (ReflectiveOperationException | RuntimeException exception) {}
        return result;
    }

    private void disposeRealm(String id) {
        try {
            this.classWorld.getClass().getMethod("disposeRealm", String.class).invoke(this.classWorld, id);
        }
        catch (ReflectiveOperationException | RuntimeException exception) {}
    }

    private static class ClassworldsConfiguration
    implements ConfigurationHandler {
        private String mainType;
        private String mainRealm;
        private LinkedHashMap<String, List<String>> realms = new LinkedHashMap();
        private List<String> curEntries;

        private ClassworldsConfiguration() {
        }

        public void setAppMain(String mainType, String mainRealm) {
            this.mainType = mainType;
            this.mainRealm = mainRealm;
        }

        public void addRealm(String realm) throws DuplicateRealmException {
            if (!this.realms.containsKey(realm)) {
                this.curEntries = new ArrayList<String>();
                this.realms.put(realm, this.curEntries);
            }
        }

        public void addImportFrom(String relamName, String importSpec) throws NoSuchRealmException {
            throw new UnsupportedOperationException();
        }

        public void addLoadFile(File file) {
            if (this.curEntries == null) {
                throw new IllegalStateException();
            }
            this.curEntries.add(file.getAbsolutePath());
        }

        public void addEntries(String realm, List<String> locations) {
            List<String> entries = this.realms.get(realm);
            if (entries == null) {
                throw new IllegalStateException();
            }
            entries.addAll(0, locations);
        }

        public void addLoadURL(URL url) {
            if (this.curEntries == null) {
                throw new IllegalStateException();
            }
            this.curEntries.add(url.toExternalForm());
        }

        public void store(OutputStream os) throws IOException {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
            out.write(String.format("main is %s from %s\n", this.mainType, this.mainRealm));
            for (Map.Entry<String, List<String>> realm : this.realms.entrySet()) {
                out.write(String.format("[%s]\n", realm.getKey()));
                for (String entry : realm.getValue()) {
                    out.write(String.format("load %s\n", entry));
                }
            }
            out.flush();
        }
    }

    private static class Key {
        private final File mavenHome;
        private final File classworldConf;
        private final List<URL> bootclasspath;
        private final List<String> extensions;
        private final List<String> args;

        public Key(File mavenHome, File classworldConf, List<URL> bootclasspath, List<String> extensions, List<String> args) {
            this.mavenHome = mavenHome;
            this.classworldConf = classworldConf;
            this.bootclasspath = Key.clone(bootclasspath);
            this.extensions = Key.clone(extensions);
            this.args = Key.clone(args);
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.mavenHome.hashCode();
            hash = hash * 31 + (this.classworldConf != null ? this.classworldConf.hashCode() : 0);
            hash = hash * 31 + (this.bootclasspath != null ? this.bootclasspath.hashCode() : 0);
            hash = hash * 31 + (this.extensions != null ? this.extensions.hashCode() : 0);
            hash = hash * 31 + (this.args != null ? this.args.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return Key.eq(this.mavenHome, other.mavenHome) && Key.eq(this.classworldConf, other.classworldConf) && Key.eq(this.bootclasspath, other.bootclasspath) && Key.eq(this.extensions, other.extensions) && Key.eq(this.args, other.args);
        }

        private static <T> List<T> clone(List<T> origin) {
            return origin != null ? new ArrayList<T>(origin) : null;
        }

        private static <T> boolean eq(T a, T b) {
            return a != null ? a.equals(b) : b == null;
        }
    }
}

