/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive;

import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.SelectorUtils;

public class Selector {
    private final List<String> includes;
    private final List<String> excludes;

    public Selector(List<String> includes, List<String> excludes) {
        this.includes = includes != null ? includes : Collections.emptyList();
        this.excludes = excludes != null ? excludes : Collections.emptyList();
    }

    public boolean include(String entryName) {
        boolean exclude = false;
        if (!this.excludes.isEmpty()) {
            for (String excludePattern : this.excludes) {
                if (!this.isExcluded(excludePattern, entryName)) continue;
                exclude = true;
                break;
            }
        }
        if (exclude) {
            return false;
        }
        boolean include = false;
        if (!this.includes.isEmpty()) {
            for (String includePattern : this.includes) {
                if (!this.isIncluded(includePattern, entryName)) continue;
                include = true;
                break;
            }
        } else {
            include = true;
        }
        return include;
    }

    private boolean isExcluded(String excludePattern, String entry) {
        return SelectorUtils.match((String)excludePattern, (String)entry);
    }

    private boolean isIncluded(String includePattern, String entry) {
        return SelectorUtils.match((String)includePattern, (String)entry);
    }
}

