/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.util.AttachmentKey;
import javax.net.ssl.SSLSession;

public class SslSessionConfig
implements SessionConfig {
    private final SessionConfig fallbackSessionConfig;
    private final AttachmentKey<Session> attachmentKey;

    public SslSessionConfig(SessionConfig fallbackSessionConfig, AttachmentKey<Session> attachmentKey) {
        this.fallbackSessionConfig = fallbackSessionConfig;
        this.attachmentKey = attachmentKey;
    }

    public SslSessionConfig(SessionConfig fallbackSessionConfig) {
        this(fallbackSessionConfig, AttachmentKey.create(Session.class));
    }

    public SslSessionConfig(AttachmentKey<Session> attachmentKey) {
        this(null, attachmentKey);
    }

    public SslSessionConfig() {
        this(null, AttachmentKey.create(Session.class));
    }

    @Override
    public void attachSession(HttpServerExchange exchange, Session session) {
        exchange.putAttachment(this.attachmentKey, session);
        SSLSession sslSession = exchange.getConnection().getSslSession();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                this.fallbackSessionConfig.attachSession(exchange, session);
            }
        } else {
            sslSession.putValue(SslSessionConfig.class.getName(), session.getId());
        }
    }

    @Override
    public void clearSession(HttpServerExchange exchange, Session session) {
        SSLSession sslSession = exchange.getConnection().getSslSession();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                this.fallbackSessionConfig.clearSession(exchange, session);
            }
        } else {
            sslSession.putValue(SslSessionConfig.class.getName(), null);
        }
    }

    @Override
    public Session getAttachedSession(HttpServerExchange exchange) {
        return exchange.getAttachment(this.attachmentKey);
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        SSLSession sslSession = exchange.getConnection().getSslSession();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                return this.fallbackSessionConfig.findSessionId(exchange);
            }
        } else {
            return (String)sslSession.getValue(SslSessionConfig.class.getName());
        }
        return null;
    }

    @Override
    public String rewriteUrl(String originalUrl, Session session) {
        return originalUrl;
    }
}

