/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.websockets.core.WebSocketFrameCorruptedException;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketHandshakeException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="UT")
public interface WebSocketMessages {
    public static final WebSocketMessages MESSAGES = (WebSocketMessages)Messages.getBundle(WebSocketMessages.class);

    @Message(id=2001, value="Not a WebSocket handshake request: missing %s in the headers")
    public WebSocketHandshakeException missingHeader(String var1);

    @Message(id=2002, value="Channel is closed")
    public IOException channelClosed();

    @Message(id=2003, value="Text frame contains non UTF-8 data")
    public UnsupportedEncodingException invalidTextFrameEncoding();

    @Message(id=2004, value="Cannot call shutdownWrites, only %s of %s bytes written")
    public IOException notAllPayloadDataWritten(long var1, long var3);

    @Message(id=2005, value="Fragmented control frame")
    public WebSocketFrameCorruptedException fragmentedControlFrame();

    @Message(id=2006, value="Control frame with payload length > 125 octets")
    public WebSocketFrameCorruptedException toBigControlFrame();

    @Message(id=2007, value="Control frame using reserved opcode = %s")
    public WebSocketFrameCorruptedException reservedOpCodeInControlFrame(int var1);

    @Message(id=2008, value="Received close control frame with payload len 1")
    public WebSocketFrameCorruptedException controlFrameWithPayloadLen1();

    @Message(id=2009, value="Data frame using reserved opcode = %s")
    public WebSocketFrameCorruptedException reservedOpCodeInDataFrame(int var1);

    @Message(id=2010, value="Received continuation data frame outside fragmented message")
    public WebSocketFrameCorruptedException continuationFrameOutsideFragmented();

    @Message(id=2011, value="Received non-continuation data frame while inside fragmented message")
    public WebSocketFrameCorruptedException nonContinuationFrameInsideFragmented();

    @Message(id=2012, value="Invalid data frame length (not using minimal length encoding)")
    public WebSocketFrameCorruptedException invalidDataFrameLength();

    @Message(id=2013, value="Cannot decode web socket frame with opcode: %s")
    public WebSocketFrameCorruptedException unsupportedOpCode(int var1);

    @Message(id=2014, value="WebSocketFrameType %s is not supported by this WebSocketChannel\"")
    public IllegalArgumentException unsupportedFrameType(WebSocketFrameType var1);

    @Message(id=2015, value="Extensions not allowed but received rsv of %s")
    public WebSocketFrameCorruptedException extensionsNotAllowed(int var1);

    @Message(id=2016, value="Could not find supported protocol in request list %s. Supported protocols are %s")
    public WebSocketHandshakeException unsupportedProtocol(String var1, Set<String> var2);

    @Message(id=2017, value="No Length encoded in the frame")
    public WebSocketFrameCorruptedException noLengthEncodedInFrame();

    @Message(id=2018, value="Payload is not support in CloseFrames when using WebSocket Version 00")
    public IllegalArgumentException payloadNotSupportedInCloseFrames();

    @Message(id=2019, value="Invalid payload for PING (payload length must be <= 125, was %s)")
    public IllegalArgumentException invalidPayloadLengthForPing(long var1);

    @Message(id=2020, value="Payload is not supported for Close Frames when using WebSocket 00")
    public IOException noPayloadAllowedForCloseFrames();

    @Message(id=2021, value="Fragmentation not supported")
    public UnsupportedOperationException fragmentationNotSupported();

    @Message(id=2022, value="Can only be changed before the write is in progress")
    public IllegalStateException writeInProgress();

    @Message(id=2023, value="Extensions not supported")
    public UnsupportedOperationException extensionsNotSupported();

    @Message(id=2024, value="The payload length must be >= 0")
    public IllegalArgumentException negativePayloadLength();

    @Message(id=2025, value="Closed before all bytes where read")
    public IOException closedBeforeAllBytesWereRead();

    @Message(id=2026, value="Invalid close frame status code: %s")
    public IOException invalidCloseFrameStatusCode(int var1);

    @Message(id=2027, value="Could not send data, as the underlying web socket connection has been broken")
    public IOException streamIsBroken();

    @Message(id=2028, value="Specified length is bigger the available size of the FileChannel")
    public IllegalArgumentException lengthBiggerThenFileChannel();

    @Message(id=2029, value="FragmentedSender was complete already")
    public IllegalArgumentException fragmentedSenderCompleteAlready();

    @Message(id=2030, value="Array of SenderCallbacks must be non empty")
    public IllegalArgumentException senderCallbacksEmpty();

    @Message(id=2031, value="Only one FragmentedSender can be used at the same time")
    public IllegalStateException fragmentedSenderInUse();

    @Message(id=2032, value="Close frame was send before")
    public IOException closeFrameSentBefore();

    @Message(id=2033, value="Blocking operation was called in IO thread")
    public IllegalStateException blockingOperationInIoThread();
}

