/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.server.HttpHandler;
import io.undertow.util.AbstractAttachable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.SslChannel;

public final class HttpServerConnection
extends AbstractAttachable
implements ConnectedChannel {
    private final StreamConnection channel;
    private final ChannelListener.Setter<HttpServerConnection> closeSetter;
    private final Pool<ByteBuffer> bufferPool;
    private final HttpHandler rootHandler;
    private final OptionMap undertowOptions;
    private final int bufferSize;
    private Pooled<ByteBuffer> extraBytes;

    public HttpServerConnection(StreamConnection channel, Pool<ByteBuffer> bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize) {
        this.channel = channel;
        this.bufferPool = bufferPool;
        this.rootHandler = rootHandler;
        this.undertowOptions = undertowOptions;
        this.bufferSize = bufferSize;
        this.closeSetter = ChannelListeners.getDelegatingSetter((ChannelListener.Setter)channel.getCloseSetter(), (Channel)((Object)this));
    }

    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    public Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    public StreamConnection getChannel() {
        return this.channel;
    }

    public ChannelListener.Setter<HttpServerConnection> getCloseSetter() {
        return this.closeSetter;
    }

    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.channel.getOption(option);
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.channel.setOption(option, value);
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public SocketAddress getPeerAddress() {
        return this.channel.getPeerAddress();
    }

    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return (A)this.channel.getPeerAddress(type);
    }

    public SocketAddress getLocalAddress() {
        return this.channel.getLocalAddress();
    }

    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return (A)this.channel.getLocalAddress(type);
    }

    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public SSLSession getSslSession() {
        if (this.channel instanceof SslChannel) {
            return ((SslChannel)this.channel).getSslSession();
        }
        return null;
    }

    public Pooled<ByteBuffer> getExtraBytes() {
        return this.extraBytes;
    }

    public void setExtraBytes(Pooled<ByteBuffer> extraBytes) {
        this.extraBytes = extraBytes;
    }
}

