/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.ConduitReadableByteChannel;
import org.xnio.conduits.StreamSourceConduit;

public class ChunkedStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final BufferWrapper bufferWrapper;
    private final ConduitListener<? super ChunkedStreamSourceConduit> finishListener;
    private long state;
    private final long maxSize;
    private long remainingAllowed;
    private static final long FLAG_READ_ENTERED = Long.MIN_VALUE;
    private static final long FLAG_CLOSED = 0x4000000000000000L;
    private static final long FLAG_SUS_RES_SHUT = 0x2000000000000000L;
    private static final long FLAG_FINISHED = 0x1000000000000000L;
    private static final long FLAG_READING_LENGTH = 0x800000000000000L;
    private static final long FLAG_READING_TILL_END_OF_LINE = 0x400000000000000L;
    private static final long FLAG_READING_NEWLINE = 0x200000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask((int)0, (int)56);

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final PushBackStreamChannel channel, final Pool<ByteBuffer> pool, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, long maxLength) {
        this(next, new BufferWrapper(){

            @Override
            public Pooled<ByteBuffer> allocate() {
                return pool.allocate();
            }

            @Override
            public void pushBack(Pooled<ByteBuffer> pooled) {
                channel.unget(pooled);
            }
        }, finishListener, maxLength);
    }

    public ChunkedStreamSourceConduit(StreamSourceConduit next, final HttpServerExchange exchange, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, long maxLength) {
        this(next, new BufferWrapper(){

            @Override
            public Pooled<ByteBuffer> allocate() {
                return exchange.getConnection().getBufferPool().allocate();
            }

            @Override
            public void pushBack(Pooled<ByteBuffer> pooled) {
                exchange.ungetRequestBytes(pooled);
            }
        }, finishListener, maxLength);
    }

    protected ChunkedStreamSourceConduit(StreamSourceConduit next, BufferWrapper bufferWrapper, ConduitListener<? super ChunkedStreamSourceConduit> finishListener, long maxLength) {
        super(next);
        this.bufferWrapper = bufferWrapper;
        this.finishListener = finishListener;
        this.remainingAllowed = maxLength;
        this.maxSize = maxLength;
        this.state = 0x800000000000000L;
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), position, count);
    }

    private void updateRemainingAllowed(int written) throws IOException {
        if (this.maxSize > 0L) {
            this.remainingAllowed -= (long)written;
            if (this.remainingAllowed < 0L) {
                throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(this.maxSize);
            }
        }
    }

    private void checkMaxLength() throws IOException {
        if (this.maxSize > 0L && this.remainingAllowed < 0L) {
            throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(this.maxSize);
        }
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)new ConduitReadableByteChannel((StreamSourceConduit)this), (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)target);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    public void terminateReads() throws IOException {
        if (!this.isFinished()) {
            super.terminateReads();
            throw UndertowMessages.MESSAGES.chunkedChannelClosedMidChunk();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        this.checkMaxLength();
        long oldVal = this.state;
        if (Bits.anyAreSet((long)oldVal, (long)0x1000000000000000L)) {
            return -1;
        }
        if (Bits.anyAreSet((long)oldVal, (long)0x4000000000000000L)) {
            throw new ClosedChannelException();
        }
        long chunkRemaining = oldVal & MASK_COUNT;
        Pooled<ByteBuffer> pooled = this.bufferWrapper.allocate();
        ByteBuffer buf = (ByteBuffer)pooled.getResource();
        int r = ((StreamSourceConduit)this.next).read(buf);
        buf.flip();
        if (r == -1) {
            throw new ClosedChannelException();
        }
        if (r == 0) {
            return 0;
        }
        long newVal = oldVal;
        try {
            int n;
            long chunkInBuffer;
            int read;
            int originalLimit;
            block45: {
                if (Bits.allAreClear((long)oldVal, (long)0xE00000000000000L) && chunkRemaining == 0L) {
                    this.state |= 0x1000000000000000L;
                    int n2 = -1;
                    return n2;
                }
                if (chunkRemaining == 0L) {
                    int c;
                    byte b;
                    while (Bits.anyAreSet((long)newVal, (long)0x200000000000000L)) {
                        while (buf.hasRemaining()) {
                            b = buf.get();
                            if (b != 10) continue;
                            newVal = newVal & 0xFDFFFFFFFFFFFFFFL | 0x800000000000000L;
                            break;
                        }
                        if (!Bits.anyAreSet((long)newVal, (long)0x200000000000000L)) continue;
                        buf.clear();
                        c = ((StreamSourceConduit)this.next).read(buf);
                        buf.flip();
                        if (c == -1) {
                            throw new ClosedChannelException();
                        }
                        if (c != 0) continue;
                        int n3 = 0;
                        return n3;
                    }
                    while (Bits.anyAreSet((long)newVal, (long)0x800000000000000L)) {
                        while (buf.hasRemaining()) {
                            b = buf.get();
                            if (b >= 48 && b <= 57 || b >= 97 && b <= 102 || b >= 65 && b <= 70) {
                                chunkRemaining <<= 4;
                                chunkRemaining += (long)Integer.parseInt("" + (char)b, 16);
                                continue;
                            }
                            if (b == 10) {
                                newVal &= 0xF7FFFFFFFFFFFFFFL;
                                break;
                            }
                            newVal = newVal & 0xF7FFFFFFFFFFFFFFL | 0x400000000000000L;
                            break;
                        }
                        if (!Bits.anyAreSet((long)newVal, (long)0x800000000000000L)) continue;
                        buf.clear();
                        c = ((StreamSourceConduit)this.next).read(buf);
                        buf.flip();
                        if (c == -1) {
                            throw new ClosedChannelException();
                        }
                        if (c != 0) continue;
                        int n4 = 0;
                        return n4;
                    }
                    while (Bits.anyAreSet((long)newVal, (long)0x400000000000000L)) {
                        while (buf.hasRemaining()) {
                            if (buf.get() != 10) continue;
                            newVal &= 0xFBFFFFFFFFFFFFFFL;
                            break;
                        }
                        if (!Bits.anyAreSet((long)newVal, (long)0x400000000000000L)) continue;
                        buf.clear();
                        c = ((StreamSourceConduit)this.next).read(buf);
                        buf.flip();
                        if (c == -1) {
                            throw new ClosedChannelException();
                        }
                        if (c != 0) continue;
                        int n5 = 0;
                        return n5;
                    }
                    if (Bits.allAreClear((long)newVal, (long)0xE00000000000000L) && chunkRemaining == 0L) {
                        newVal |= 0x1000000000000000L;
                        c = -1;
                        return c;
                    }
                }
                originalLimit = dst.limit();
                read = 0;
                chunkInBuffer = Math.min((long)buf.remaining(), chunkRemaining);
                int remaining = dst.remaining();
                if (chunkInBuffer <= (long)remaining) break block45;
                int orig = buf.limit();
                buf.limit(buf.position() + remaining);
                dst.put(buf);
                buf.limit(orig);
                chunkRemaining -= (long)remaining;
                this.updateRemainingAllowed(remaining);
                int n6 = remaining;
                dst.limit(originalLimit);
                return n6;
            }
            try {
                int old;
                if (buf.hasRemaining()) {
                    old = buf.limit();
                    buf.limit((int)Math.min((long)old, (long)buf.position() + chunkInBuffer));
                    try {
                        dst.put(buf);
                    }
                    finally {
                        buf.limit(old);
                    }
                    read = (int)((long)read + chunkInBuffer);
                    chunkRemaining -= chunkInBuffer;
                }
                if (chunkRemaining > 0L) {
                    old = dst.limit();
                    try {
                        if (chunkRemaining < (long)dst.remaining()) {
                            dst.limit((int)((long)dst.position() + chunkRemaining));
                        }
                        int c = 0;
                        do {
                            if ((c = ((StreamSourceConduit)this.next).read(dst)) <= 0) continue;
                            read += c;
                            chunkRemaining -= (long)c;
                        } while (c > 0 && chunkRemaining > 0L);
                        if (c == -1) {
                            newVal |= 0x1000000000000000L;
                        }
                    }
                    finally {
                        dst.limit(old);
                    }
                }
                if (chunkRemaining == 0L) {
                    newVal |= 0x200000000000000L;
                }
                this.updateRemainingAllowed(read);
                n = read;
                dst.limit(originalLimit);
            }
            catch (Throwable throwable) {
                dst.limit(originalLimit);
                throw throwable;
            }
            return n;
        }
        finally {
            this.state = newVal = newVal & (MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL) | chunkRemaining;
            if (buf.hasRemaining()) {
                this.bufferWrapper.pushBack(pooled);
            }
            if (Bits.allAreClear((long)oldVal, (long)0x1000000000000000L) && Bits.allAreSet((long)newVal, (long)0x1000000000000000L)) {
                this.callFinish();
            }
        }
    }

    public boolean isFinished() {
        return Bits.anyAreSet((long)this.state, (long)0x1000000000000000L);
    }

    private void callFinish() {
        this.finishListener.handleEvent(this);
    }

    static interface BufferWrapper {
        public Pooled<ByteBuffer> allocate();

        public void pushBack(Pooled<ByteBuffer> var1);
    }
}

