/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.session.SessionConfig;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.SecurityRoleRef;
import io.undertow.servlet.core.ServletUpgradeListener;
import io.undertow.servlet.handlers.ServletAttachments;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.spec.AsyncContextImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.PartImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.spec.ServletInputStreamImpl;
import io.undertow.servlet.util.EmptyEnumeration;
import io.undertow.servlet.util.IteratorEnumeration;
import io.undertow.util.AttachmentKey;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.LocaleUtils;
import io.undertow.util.Methods;
import io.undertow.util.QValueParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.xnio.LocalSocketAddress;

public final class HttpServletRequestImpl
implements HttpServletRequest {
    public static final AttachmentKey<ServletRequest> ATTACHMENT_KEY = AttachmentKey.create(ServletRequest.class);
    public static final AttachmentKey<DispatcherType> DISPATCHER_TYPE_ATTACHMENT_KEY = AttachmentKey.create(DispatcherType.class);
    private static final Charset DEFAULT_CHARSET = Charset.forName("ISO-8859-1");
    private final HttpServerExchange exchange;
    private ServletContextImpl servletContext;
    private final List<BoundAsyncListener> asyncListeners = new CopyOnWriteArrayList<BoundAsyncListener>();
    private Map<String, Object> attributes = null;
    private ServletInputStream servletInputStream;
    private BufferedReader reader;
    private Cookie[] cookies;
    private List<Part> parts = null;
    private volatile AsyncContextImpl asyncContext = null;
    private Map<String, Deque<String>> queryParameters;
    private FormData parsedFormData;
    private Charset characterEncoding;
    private boolean readStarted;

    public HttpServletRequestImpl(HttpServerExchange exchange, ServletContextImpl servletContext) {
        this.exchange = exchange;
        this.servletContext = servletContext;
        this.queryParameters = exchange.getQueryParameters();
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    public String getAuthType() {
        SecurityContext securityContext = (SecurityContext)this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        return securityContext != null ? securityContext.getMechanismName() : null;
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            Map cookies = CookieImpl.getRequestCookies((HttpServerExchange)this.exchange);
            if (cookies.isEmpty()) {
                return null;
            }
            Cookie[] value = new Cookie[cookies.size()];
            int i = 0;
            for (Map.Entry entry : cookies.entrySet()) {
                io.undertow.server.handlers.Cookie cookie = (io.undertow.server.handlers.Cookie)entry.getValue();
                Cookie c = new Cookie(cookie.getName(), cookie.getValue());
                if (cookie.getDomain() != null) {
                    c.setDomain(cookie.getDomain());
                }
                c.setHttpOnly(cookie.isHttpOnly());
                if (cookie.getMaxAge() != null) {
                    c.setMaxAge(cookie.getMaxAge().intValue());
                }
                if (cookie.getPath() != null) {
                    c.setPath(cookie.getPath());
                }
                c.setSecure(cookie.isSecure());
                c.setVersion(cookie.getVersion());
                value[i++] = c;
            }
            this.cookies = value;
        }
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String header = this.exchange.getRequestHeaders().getFirst(new HttpString(name));
        if (header == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate((String)header);
        if (date == null) {
            throw UndertowServletMessages.MESSAGES.headerCannotBeConvertedToDate(header);
        }
        return date.getTime();
    }

    public String getHeader(String name) {
        return this.getHeader(new HttpString(name));
    }

    public String getHeader(HttpString name) {
        HeaderMap headers = this.exchange.getRequestHeaders();
        if (headers == null) {
            return null;
        }
        return headers.getFirst(name);
    }

    public Enumeration<String> getHeaders(String name) {
        List headers = this.exchange.getRequestHeaders().get(new HttpString(name));
        if (headers == null) {
            return EmptyEnumeration.instance();
        }
        return new IteratorEnumeration<String>(headers.iterator());
    }

    public Enumeration<String> getHeaderNames() {
        HashSet<String> headers = new HashSet<String>();
        for (HttpString i : this.exchange.getRequestHeaders()) {
            headers.add(i.toString());
        }
        return new IteratorEnumeration<String>(headers.iterator());
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1;
        }
        return Integer.parseInt(header);
    }

    public String getMethod() {
        return this.exchange.getRequestMethod().toString();
    }

    public String getPathInfo() {
        ServletPathMatch match = (ServletPathMatch)this.exchange.getAttachment(ServletAttachments.SERVLET_PATH_MATCH);
        if (match != null) {
            return match.getRemaining();
        }
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getQueryString() {
        return this.exchange.getQueryString();
    }

    public String getRemoteUser() {
        Principal userPrincipal = this.getUserPrincipal();
        return userPrincipal != null ? userPrincipal.getName() : null;
    }

    public boolean isUserInRole(String role) {
        SecurityContext sc = (SecurityContext)this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        Account account = sc.getAuthenticatedAccount();
        if (account == null) {
            return false;
        }
        ServletChain servlet = (ServletChain)this.exchange.getAttachment(ServletAttachments.CURRENT_SERVLET);
        for (SecurityRoleRef ref : servlet.getManagedServlet().getServletInfo().getSecurityRoleRefs()) {
            if (!ref.getRole().equals(role)) continue;
            return account.isUserInRole(ref.getLinkedRole());
        }
        return account.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        SecurityContext securityContext = (SecurityContext)this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        Principal result = null;
        Account account = null;
        if (securityContext != null && (account = securityContext.getAuthenticatedAccount()) != null) {
            result = account.getPrincipal();
        }
        return result;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String changeSessionId() {
        HttpSessionImpl session = this.servletContext.getSession(this.exchange, false);
        if (session == null) {
            throw UndertowServletMessages.MESSAGES.noSession();
        }
        String oldId = session.getId();
        String newId = session.getSession().changeSessionId(this.exchange, (SessionConfig)this.servletContext.getSessionCookieConfig());
        this.servletContext.getDeployment().getApplicationListeners().httpSessionIdChanged(session, oldId);
        return newId;
    }

    public String getRequestURI() {
        return this.exchange.getRequestPath();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.exchange.getRequestURL());
    }

    public String getServletPath() {
        ServletPathMatch match = (ServletPathMatch)this.exchange.getAttachment(ServletAttachments.SERVLET_PATH_MATCH);
        if (match != null) {
            return match.getMatched();
        }
        return "";
    }

    public HttpSession getSession(boolean create) {
        return this.servletContext.getSession(this.exchange, create);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        HttpSessionImpl session = this.servletContext.getSession(this.exchange, false);
        return session != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        HttpSessionImpl session = this.servletContext.getSession(this.exchange, false);
        return session != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw UndertowServletMessages.MESSAGES.responseAlreadyCommited();
        }
        SecurityContext sc = (SecurityContext)this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        sc.setAuthenticationRequired();
        if (sc.authenticate()) {
            if (sc.isAuthenticated()) {
                return true;
            }
            throw UndertowServletMessages.MESSAGES.authenticationFailed();
        }
        HttpServletResponseImpl responseImpl = HttpServletResponseImpl.getResponseImpl((ServletResponse)response);
        responseImpl.closeStreamAndWriter();
        return false;
    }

    public void login(String username, String password) throws ServletException {
        if (username == null || password == null) {
            throw UndertowServletMessages.MESSAGES.loginFailed();
        }
        SecurityContext sc = (SecurityContext)this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        if (sc.isAuthenticated()) {
            throw UndertowServletMessages.MESSAGES.userAlreadyLoggedIn();
        }
        if (!sc.login(username, password)) {
            throw UndertowServletMessages.MESSAGES.loginFailed();
        }
    }

    public void logout() throws ServletException {
        SecurityContext sc = (SecurityContext)this.exchange.getAttachment(SecurityContext.ATTACHMENT_KEY);
        sc.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.parts == null) {
            this.loadParts();
        }
        return this.parts;
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.parts == null) {
            this.loadParts();
        }
        for (Part part : this.parts) {
            if (!part.getName().equals(name)) continue;
            return part;
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException {
        try {
            InstanceFactory<T> factory = this.servletContext.getDeployment().getDeploymentInfo().getClassIntrospecter().createInstanceFactory(handlerClass);
            InstanceHandle<T> instance = factory.createInstance();
            this.exchange.upgradeChannel(new ServletUpgradeListener<T>(instance));
            return (T)((HttpUpgradeHandler)instance.getInstance());
        }
        catch (InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadParts() throws IOException, ServletException {
        this.readStarted = true;
        if (this.parts == null) {
            ArrayList<Part> parts = new ArrayList<Part>();
            String mimeType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
            if (mimeType != null && mimeType.startsWith("multipart/form-data")) {
                FormDataParser parser = (FormDataParser)this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
                FormData value = parser.parseBlocking();
                for (String namedPart : value) {
                    for (FormData.FormValue part : value.get(namedPart)) {
                        parts.add(new PartImpl(namedPart, part));
                    }
                }
            } else {
                throw UndertowServletMessages.MESSAGES.notAMultiPartRequest();
            }
            this.parts = parts;
        }
    }

    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.emptyEnumeration();
        }
        return new IteratorEnumeration<String>(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding != null) {
            return this.characterEncoding.name();
        }
        String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        return Headers.extractTokenFromHeader((String)contentType, (String)"charset");
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.readStarted) {
            return;
        }
        try {
            this.characterEncoding = Charset.forName(env);
            FormDataParser parser = (FormDataParser)this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                parser.setCharacterEncoding(env);
            }
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException();
        }
    }

    public int getContentLength() {
        String contentLength = this.getHeader(Headers.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1;
        }
        return Integer.parseInt(contentLength);
    }

    public long getContentLengthLong() {
        String contentLength = this.getHeader(Headers.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        return Long.parseLong(contentLength);
    }

    public String getContentType() {
        return this.getHeader(Headers.CONTENT_TYPE);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.reader != null) {
            throw UndertowServletMessages.MESSAGES.getReaderAlreadyCalled();
        }
        this.servletInputStream = new ServletInputStreamImpl(this);
        this.readStarted = true;
        return this.servletInputStream;
    }

    public String getParameter(String name) {
        Deque<String> params = this.queryParameters.get(name);
        if (params == null) {
            if (this.exchange.getRequestMethod().equals(Methods.POST)) {
                FormData.FormValue res;
                if (this.parsedFormData == null) {
                    if (this.readStarted) {
                        return null;
                    }
                    this.readStarted = true;
                    FormDataParser parser = (FormDataParser)this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
                    if (parser == null) {
                        return null;
                    }
                    try {
                        this.parsedFormData = parser.parseBlocking();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if ((res = this.parsedFormData.getFirst(name)) == null) {
                    return null;
                }
                return res.getValue();
            }
            return null;
        }
        try {
            return URLDecoder.decode(params.getFirst(), this.characterEncoding == null ? "ISO-8859-1" : this.characterEncoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Enumeration<String> getParameterNames() {
        HashSet<String> parameterNames = new HashSet<String>(this.queryParameters.keySet());
        if (this.exchange.getRequestMethod().equals(Methods.POST)) {
            this.readStarted = true;
            FormDataParser parser = (FormDataParser)this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                try {
                    FormData formData = parser.parseBlocking();
                    Iterator it = formData.iterator();
                    while (it.hasNext()) {
                        parameterNames.add((String)it.next());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new IteratorEnumeration<String>(parameterNames.iterator());
    }

    public String[] getParameterValues(String name) {
        ArrayList<String> ret = new ArrayList<String>();
        Deque<String> params = this.queryParameters.get(name);
        if (params != null) {
            for (String param : params) {
                try {
                    ret.add(URLDecoder.decode(param, this.characterEncoding == null ? "ISO-8859-1" : this.characterEncoding.name()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.exchange.getRequestMethod().equals(Methods.POST)) {
            this.readStarted = true;
            FormDataParser parser = (FormDataParser)this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                try {
                    Deque res = parser.parseBlocking().get(name);
                    if (res == null) {
                        return null;
                    }
                    for (FormData.FormValue value : res) {
                        ret.add(value.getValue());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        for (Map.Entry<String, Deque<String>> entry : this.queryParameters.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().toArray(new String[entry.getValue().size()]));
        }
        if (this.exchange.getRequestMethod().equals(Methods.POST)) {
            this.readStarted = true;
            FormDataParser parser = (FormDataParser)this.exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
            if (parser != null) {
                try {
                    FormData formData = parser.parseBlocking();
                    for (String name : formData) {
                        Deque val = formData.get(name);
                        if (ret.containsKey(name)) {
                            String[] existing = (String[])ret.get(name);
                            String[] array = new String[val.size() + existing.length];
                            System.arraycopy(existing, 0, array, 0, existing.length);
                            int i = existing.length;
                            for (FormData.FormValue v : val) {
                                array[i++] = v.getValue();
                            }
                            ret.put(name, array);
                            continue;
                        }
                        String[] array = new String[val.size()];
                        int i = 0;
                        for (FormData.FormValue v : val) {
                            array[i++] = v.getValue();
                        }
                        ret.put(name, array);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ret;
    }

    public String getProtocol() {
        return this.exchange.getProtocol().toString();
    }

    public String getScheme() {
        return this.exchange.getRequestScheme();
    }

    public String getServerName() {
        return this.exchange.getDestinationAddress().getHostName();
    }

    public int getServerPort() {
        return this.exchange.getDestinationAddress().getPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            if (this.servletInputStream != null) {
                throw UndertowServletMessages.MESSAGES.getInputStreamAlreadyCalled();
            }
            Charset charSet = DEFAULT_CHARSET;
            if (this.characterEncoding != null) {
                charSet = this.characterEncoding;
            } else {
                String c;
                String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
                if (contentType != null && (c = Headers.extractTokenFromHeader((String)contentType, (String)"charset")) != null) {
                    try {
                        charSet = Charset.forName(c);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new UnsupportedEncodingException();
                    }
                }
            }
            this.reader = new BufferedReader(new InputStreamReader(this.exchange.getInputStream(), charSet));
        }
        this.readStarted = true;
        return this.reader;
    }

    public String getRemoteAddr() {
        return this.exchange.getSourceAddress().getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.exchange.getSourceAddress().getHostName();
    }

    public void setAttribute(String name, Object object) {
        Object existing;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if ((existing = this.attributes.put(name, object)) != null) {
            this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeReplaced(this, name, existing);
        } else {
            this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeAdded(this, name, object);
        }
    }

    public void removeAttribute(String name) {
        if (this.attributes == null) {
            return;
        }
        Object exiting = this.attributes.remove(name);
        this.servletContext.getDeployment().getApplicationListeners().servletRequestAttributeRemoved(this, name, exiting);
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration<Locale> getLocales() {
        List acceptLanguage = this.exchange.getRequestHeaders().get(Headers.ACCEPT_LANGUAGE);
        if (acceptLanguage == null || acceptLanguage.isEmpty()) {
            return new IteratorEnumeration<Locale>(Collections.singleton(Locale.getDefault()).iterator());
        }
        ArrayList<Locale> ret = new ArrayList<Locale>();
        List parsedResults = QValueParser.parse((List)acceptLanguage);
        for (List qvalueResult : parsedResults) {
            for (QValueParser.QValueResult res : qvalueResult) {
                if (res.isQValueZero()) continue;
                Locale e = LocaleUtils.getLocaleFromString((String)res.getValue());
                ret.add(e);
            }
        }
        return new IteratorEnumeration<Locale>(ret.iterator());
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        String realPath;
        if (path.startsWith("/")) {
            realPath = path;
        } else {
            String current = this.exchange.getRelativePath();
            int lastSlash = current.lastIndexOf("/");
            if (lastSlash != -1) {
                current = current.substring(0, lastSlash + 1);
            }
            realPath = CanonicalPathUtils.canonicalize((String)(current + path));
        }
        return new RequestDispatcherImpl(realPath, this.servletContext);
    }

    public String getRealPath(String path) {
        return null;
    }

    public int getRemotePort() {
        return this.exchange.getSourceAddress().getPort();
    }

    public String getLocalName() {
        return this.exchange.getDestinationAddress().getHostName();
    }

    public String getLocalAddr() {
        SocketAddress address = this.exchange.getConnection().getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostName();
        }
        if (address instanceof LocalSocketAddress) {
            return ((LocalSocketAddress)address).getName();
        }
        return null;
    }

    public int getLocalPort() {
        SocketAddress address = this.exchange.getConnection().getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getPort();
        }
        return -1;
    }

    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw UndertowServletMessages.MESSAGES.startAsyncNotAllowed();
        }
        if (this.asyncContext != null) {
            throw UndertowServletMessages.MESSAGES.asyncAlreadyStarted();
        }
        this.onAsyncStart();
        this.asyncListeners.clear();
        this.asyncContext = new AsyncContextImpl(this.exchange, (ServletRequest)this.exchange.getAttachment(ATTACHMENT_KEY), (ServletResponse)this.exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY));
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw UndertowServletMessages.MESSAGES.startAsyncNotAllowed();
        }
        if (this.asyncContext != null) {
            throw UndertowServletMessages.MESSAGES.asyncAlreadyStarted();
        }
        this.onAsyncStart();
        this.asyncListeners.clear();
        this.asyncContext = new AsyncContextImpl(this.exchange, servletRequest, servletResponse);
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncContext != null;
    }

    public boolean isAsyncSupported() {
        Boolean supported = (Boolean)this.exchange.getAttachment(AsyncContextImpl.ASYNC_SUPPORTED);
        return supported == null || supported != false;
    }

    public AsyncContextImpl getAsyncContext() {
        if (this.asyncContext == null) {
            throw UndertowServletMessages.MESSAGES.asyncNotStarted();
        }
        return this.asyncContext;
    }

    public DispatcherType getDispatcherType() {
        return (DispatcherType)this.exchange.getAttachment(DISPATCHER_TYPE_ATTACHMENT_KEY);
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, Deque<String>> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setServletContext(ServletContextImpl servletContext) {
        this.servletContext = servletContext;
    }

    void asyncRequestDispatched() {
        this.asyncContext = null;
    }

    public static HttpServletRequestImpl getRequestImpl(ServletRequest request) {
        HttpServletRequestImpl requestImpl;
        if (request instanceof HttpServletRequestImpl) {
            requestImpl = (HttpServletRequestImpl)request;
        } else if (request instanceof ServletRequestWrapper) {
            requestImpl = HttpServletRequestImpl.getRequestImpl(((ServletRequestWrapper)request).getRequest());
        } else {
            throw UndertowServletMessages.MESSAGES.requestWasNotOriginalOrWrapper(request);
        }
        return requestImpl;
    }

    public void addAsyncListener(AsyncListener listener) {
        this.asyncListeners.add(new BoundAsyncListener(listener, (ServletRequest)this, (ServletResponse)this.exchange.getAttachment(HttpServletResponseImpl.ATTACHMENT_KEY)));
    }

    public void addAsyncListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        this.asyncListeners.add(new BoundAsyncListener(listener, servletRequest, servletResponse));
    }

    public void onAsyncComplete() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent((AsyncContext)this.asyncContext, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onComplete(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    public void onAsyncTimeout() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent((AsyncContext)this.asyncContext, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onTimeout(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    public void onAsyncStart() {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent((AsyncContext)this.asyncContext, listener.servletRequest, listener.servletResponse);
            try {
                listener.asyncListener.onStartAsync(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    public void onAsyncError(Throwable t) {
        for (BoundAsyncListener listener : this.asyncListeners) {
            AsyncEvent event = new AsyncEvent((AsyncContext)this.asyncContext, listener.servletRequest, listener.servletResponse, t);
            try {
                listener.asyncListener.onStartAsync(event);
            }
            catch (IOException e) {
                UndertowServletLogger.REQUEST_LOGGER.ioExceptionDispatchingAsyncEvent(e);
            }
        }
    }

    private final class BoundAsyncListener {
        final AsyncListener asyncListener;
        final ServletRequest servletRequest;
        final ServletResponse servletResponse;

        private BoundAsyncListener(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.asyncListener = asyncListener;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }
    }
}

