package io.undertow.servlet;

import java.util.Locale;
import java.nio.file.Path;
import java.lang.IllegalStateException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.Serializable;
import java.net.MalformedURLException;
import javax.annotation.Generated;
import java.lang.String;
import java.io.IOException;
import java.lang.Exception;
import javax.servlet.ServletException;
import java.lang.RuntimeException;
import io.undertow.servlet.api.DeploymentManager.State;
import java.lang.NullPointerException;
import java.lang.Class;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2020-03-11T01:35:39-0300")
public class UndertowServletMessages_$bundle implements UndertowServletMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected UndertowServletMessages_$bundle() {}
    public static final UndertowServletMessages_$bundle INSTANCE = new UndertowServletMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String paramCannotBeNull1$str() {
        return "UT010000: %s cannot be null";
    }
    @Override
    public final IllegalArgumentException paramCannotBeNull(final String param) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramCannotBeNull1$str(), param));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String paramCannotBeNull3$str() {
        return "UT010001: %s cannot be null for %s named %s";
    }
    @Override
    public final IllegalArgumentException paramCannotBeNull(final String param, final String componentType, final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), paramCannotBeNull3$str(), param, componentType, name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String canOnlyRemoveDeploymentsWhenUndeployed$str() {
        return "UT010002: Deployments can only be removed when in undeployed state, but state was %s";
    }
    @Override
    public final IllegalStateException canOnlyRemoveDeploymentsWhenUndeployed(final State state) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), canOnlyRemoveDeploymentsWhenUndeployed$str(), state));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getReaderAlreadyCalled$str() {
        return "UT010003: Cannot call getInputStream(), getReader() already called";
    }
    @Override
    public final IllegalStateException getReaderAlreadyCalled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getReaderAlreadyCalled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getInputStreamAlreadyCalled$str() {
        return "UT010004: Cannot call getReader(), getInputStream() already called";
    }
    @Override
    public final IllegalStateException getInputStreamAlreadyCalled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getInputStreamAlreadyCalled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getWriterAlreadyCalled$str() {
        return "UT010005: Cannot call getOutputStream(), getWriter() already called";
    }
    @Override
    public final IllegalStateException getWriterAlreadyCalled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getWriterAlreadyCalled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String getOutputStreamAlreadyCalled$str() {
        return "UT010006: Cannot call getWriter(), getOutputStream() already called";
    }
    @Override
    public final IllegalStateException getOutputStreamAlreadyCalled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), getOutputStreamAlreadyCalled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String twoServletsWithSameMapping$str() {
        return "UT010007: Two servlets specified with same mapping %s";
    }
    @Override
    public final IllegalArgumentException twoServletsWithSameMapping(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), twoServletsWithSameMapping$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String headerCannotBeConvertedToDate$str() {
        return "UT010008: Header %s cannot be converted to a date";
    }
    @Override
    public final IllegalArgumentException headerCannotBeConvertedToDate(final String header) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), headerCannotBeConvertedToDate$str(), header));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String servletMustImplementServlet$str() {
        return "UT010009: Servlet %s of type %s does not implement javax.servlet.Servlet";
    }
    @Override
    public final IllegalArgumentException servletMustImplementServlet(final String name, final Class<? extends javax.servlet.Servlet> servletClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), servletMustImplementServlet$str(), name, servletClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String componentMustHaveDefaultConstructor$str() {
        return "UT010010: %s of type %s must have a default constructor";
    }
    @Override
    public final IllegalArgumentException componentMustHaveDefaultConstructor(final String componentType, final Class<?> componentClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), componentMustHaveDefaultConstructor$str(), componentType, componentClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String filterMustImplementFilter$str() {
        return "UT010011: Filter %s of type %s does not implement javax.servlet.Filter";
    }
    @Override
    public final IllegalArgumentException filterMustImplementFilter(final String name, final Class<? extends javax.servlet.Filter> filterClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), filterMustImplementFilter$str(), name, filterClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String listenerMustImplementListenerClass$str() {
        return "UT010012: Listener class %s must implement at least one listener interface";
    }
    @Override
    public final IllegalArgumentException listenerMustImplementListenerClass(final Class<?> listenerClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), listenerMustImplementListenerClass$str(), listenerClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotInstantiateComponent$str() {
        return "UT010013: Could not instantiate %s";
    }
    @Override
    public final ServletException couldNotInstantiateComponent(final String name, final Exception e) {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), couldNotInstantiateComponent$str(), name), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotLoadClass$str() {
        return "UT010014: Could not load class %s";
    }
    @Override
    public final RuntimeException cannotLoadClass(final String className, final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotLoadClass$str(), className), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deleteFailed$str() {
        return "UT010015: Could not delete file %s";
    }
    @Override
    public final IOException deleteFailed(final Path file) {
        final IOException result = new IOException(String.format(getLoggingLocale(), deleteFailed$str(), file));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAMultiPartRequest$str() {
        return "UT010016: Not a multi part request";
    }
    @Override
    public final ServletException notAMultiPartRequest() {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), notAMultiPartRequest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asyncNotStarted$str() {
        return "UT010018: Async not started";
    }
    @Override
    public final IllegalStateException asyncNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), asyncNotStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseAlreadyCommited$str() {
        return "UT010019: Response already commited";
    }
    @Override
    public final IllegalStateException responseAlreadyCommited() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), responseAlreadyCommited$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String contentHasBeenWritten$str() {
        return "UT010020: Content has been written";
    }
    @Override
    public final IllegalStateException contentHasBeenWritten() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), contentHasBeenWritten$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathMustStartWithSlash$str() {
        return "UT010021: Path %s must start with a /";
    }
    @Override
    public final MalformedURLException pathMustStartWithSlash(final String path) {
        final MalformedURLException result = new MalformedURLException(String.format(getLoggingLocale(), pathMustStartWithSlash$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionIsInvalid$str() {
        return "UT010022: Session is invalid";
    }
    @Override
    public final IllegalStateException sessionIsInvalid() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sessionIsInvalid$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestWasNotOriginalOrWrapper$str() {
        return "UT010023: Request %s was not original or a wrapper";
    }
    @Override
    public final IllegalArgumentException requestWasNotOriginalOrWrapper(final ServletRequest request) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requestWasNotOriginalOrWrapper$str(), request));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseWasNotOriginalOrWrapper$str() {
        return "UT010024: Response %s was not original or a wrapper";
    }
    @Override
    public final IllegalArgumentException responseWasNotOriginalOrWrapper(final ServletResponse response) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), responseWasNotOriginalOrWrapper$str(), response));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asyncRequestAlreadyDispatched$str() {
        return "UT010025: Async request already dispatched";
    }
    @Override
    public final IllegalStateException asyncRequestAlreadyDispatched() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), asyncRequestAlreadyDispatched$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String startAsyncNotAllowed$str() {
        return "UT010026: Async is not supported for this request, as not all filters or Servlets were marked as supporting async";
    }
    @Override
    public final IllegalStateException startAsyncNotAllowed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), startAsyncNotAllowed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notImplemented$str() {
        return "UT010027: Not implemented";
    }
    @Override
    public final IllegalStateException notImplemented() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notImplemented$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asyncAlreadyStarted$str() {
        return "UT010028: Async processing already started";
    }
    @Override
    public final IllegalStateException asyncAlreadyStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), asyncAlreadyStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String streamIsClosed$str() {
        return "UT010029: Stream is closed";
    }
    @Override
    public final IOException streamIsClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamIsClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userAlreadyLoggedIn$str() {
        return "UT010030: User already logged in";
    }
    @Override
    public final ServletException userAlreadyLoggedIn() {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), userAlreadyLoggedIn$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String loginFailed$str() {
        return "UT010031: Login failed";
    }
    @Override
    public final ServletException loginFailed() {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), loginFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailed$str() {
        return "UT010032: Authenticationfailed";
    }
    @Override
    public final ServletException authenticationFailed() {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), authenticationFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSession$str() {
        return "UT010033: No session";
    }
    @Override
    public final IllegalStateException noSession() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSession$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String streamNotInAsyncMode$str() {
        return "UT010034: Stream not in async mode";
    }
    @Override
    public final IllegalStateException streamNotInAsyncMode() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), streamNotInAsyncMode$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String streamNotReady$str() {
        return "UT010035: Stream in async mode was not ready for IO operation";
    }
    @Override
    public final IllegalStateException streamNotReady() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), streamNotReady$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String listenerAlreadySet$str() {
        return "UT010036: Listener has already been set";
    }
    @Override
    public final IllegalStateException listenerAlreadySet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), listenerAlreadySet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noWebSocketHandler$str() {
        return "UT010038: No web socket handler was provided to the web socket servlet";
    }
    @Override
    public final ServletException noWebSocketHandler() {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), noWebSocketHandler$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAuthenticationMechanism$str() {
        return "UT010039: Unknown authentication mechanism %s";
    }
    @Override
    public final RuntimeException unknownAuthenticationMechanism(final String mechName) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unknownAuthenticationMechanism$str(), mechName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String moreThanOneDefaultErrorPage$str() {
        return "UT010040: More than one default error page %s and %s";
    }
    @Override
    public final IllegalStateException moreThanOneDefaultErrorPage(final String defaultErrorPage, final String location) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), moreThanOneDefaultErrorPage$str(), defaultErrorPage, location));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String servletContextAlreadyInitialized$str() {
        return "UT010041: The servlet context has already been initialized, you can only call this method from a ServletContainerInitializer or a ServletContextListener";
    }
    @Override
    public final IllegalStateException servletContextAlreadyInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), servletContextAlreadyInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotCallFromProgramaticListener$str() {
        return "UT010042: This method cannot be called from a servlet context listener that has been added programatically";
    }
    @Override
    public final UnsupportedOperationException cannotCallFromProgramaticListener() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), cannotCallFromProgramaticListener$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAddServletContextListener$str() {
        return "UT010043: Cannot add servlet context listener from a programatically added listener";
    }
    @Override
    public final IllegalArgumentException cannotAddServletContextListener() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotAddServletContextListener$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String listenerCannotBeNull$str() {
        return "UT010044: listener cannot be null";
    }
    @Override
    public final NullPointerException listenerCannotBeNull() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), listenerCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sslCannotBeCombinedWithAnyOtherMethod$str() {
        return "UT010045: SSL cannot be combined with any other method";
    }
    @Override
    public final IllegalArgumentException sslCannotBeCombinedWithAnyOtherMethod() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), sslCannotBeCombinedWithAnyOtherMethod$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotFindContextToDispatchTo$str() {
        return "UT010046: No servlet context at %s to dispatch to";
    }
    @Override
    public final IllegalArgumentException couldNotFindContextToDispatchTo(final String originalContextPath) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotFindContextToDispatchTo$str(), originalContextPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullName$str() {
        return "UT010047: Name was null";
    }
    @Override
    public final NullPointerException nullName() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidRequestResponseType$str() {
        return "UT010048: Can only handle HTTP type of request / response: %s / %s";
    }
    @Override
    public final IllegalArgumentException invalidRequestResponseType(final ServletRequest request, final ServletResponse response) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidRequestResponseType$str(), request, response));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String asyncRequestAlreadyReturnedToContainer$str() {
        return "UT010049: Async request already returned to container";
    }
    @Override
    public final IllegalStateException asyncRequestAlreadyReturnedToContainer() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), asyncRequestAlreadyReturnedToContainer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String filterNotFound$str() {
        return "UT010050: Filter %s used in filter mapping %s not found";
    }
    @Override
    public final IllegalStateException filterNotFound(final String filterName, final String mapping) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), filterNotFound$str(), filterName, mapping));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentStopped$str() {
        return "UT010051: Deployment %s has stopped";
    }
    @Override
    public final ServletException deploymentStopped(final String deployment) {
        final ServletException result = new ServletException(String.format(getLoggingLocale(), deploymentStopped$str(), deployment));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String headerNameWasNull$str() {
        return "UT010052: Header name was null";
    }
    @Override
    public final NullPointerException headerNameWasNull() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), headerNameWasNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfidentialPortAvailable$str() {
        return "UT010053: No confidential port is available to redirect the current request.";
    }
    @Override
    public final IllegalStateException noConfidentialPortAvailable() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noConfidentialPortAvailable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotCreateFactory$str() {
        return "UT010054: Unable to create an instance factory for %s";
    }
    @Override
    public final RuntimeException couldNotCreateFactory(final String className, final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotCreateFactory$str(), className), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String listenerIsNotStarted$str() {
        return "UT010055: Listener is not started";
    }
    @Override
    public final IllegalStateException listenerIsNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), listenerIsNotStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathWasNotSet$str() {
        return "UT010056: path was not set";
    }
    @Override
    public final IllegalStateException pathWasNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), pathWasNotSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipartConfigNotPresent$str() {
        return "UT010057: multipart config was not present on Servlet";
    }
    @Override
    public final IllegalStateException multipartConfigNotPresent() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipartConfigNotPresent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String servletNameNull$str() {
        return "UT010058: Servlet name cannot be null";
    }
    @Override
    public final IllegalArgumentException servletNameNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), servletNameNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String paramCannotBeNullNPE$str() {
        return "UT010059: Param %s cannot be null";
    }
    @Override
    public final NullPointerException paramCannotBeNullNPE(final String name) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), paramCannotBeNullNPE$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String trailersNotSupported$str() {
        return "UT010060: Trailers not supported for this request due to %s";
    }
    @Override
    public final IllegalStateException trailersNotSupported(final String reason) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), trailersNotSupported$str(), reason));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMethodForPushRequest$str() {
        return "UT010061: Invalid method for push request %s";
    }
    @Override
    public final IllegalArgumentException invalidMethodForPushRequest(final String method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMethodForPushRequest$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
