/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.FragmentedBinaryFrameSender;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.xnio.Pool;
import org.xnio.Pooled;

final class BinaryOutputStream
extends OutputStream {
    private final FragmentedBinaryFrameSender sender;
    private final Pooled<ByteBuffer> pooled;
    private boolean closed;

    BinaryOutputStream(FragmentedBinaryFrameSender sender, Pool<ByteBuffer> pool) {
        this.sender = sender;
        this.pooled = pool.allocate();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        ByteBuffer buffer = (ByteBuffer)this.pooled.getResource();
        int remaining = buffer.remaining();
        if (remaining >= len) {
            buffer.put(b, off, len);
            this.send(false, false);
        } else {
            for (int left = len - remaining; left > 0; left -= remaining) {
                buffer.put(b, off, remaining);
                this.send(false, false);
                remaining = buffer.remaining();
            }
        }
    }

    private void send(boolean force, boolean last) throws IOException {
        ByteBuffer buffer = (ByteBuffer)this.pooled.getResource();
        if (force || !buffer.hasRemaining()) {
            buffer.flip();
            if (last) {
                this.sender.finalFragment();
            }
            this.sender.sendBinary(buffer);
            buffer.clear();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        ByteBuffer buffer = (ByteBuffer)this.pooled.getResource();
        buffer.put((byte)b);
        this.send(false, false);
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.send(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.closed = true;
                this.send(true, true);
            }
            finally {
                this.pooled.free();
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw JsrWebSocketMessages.MESSAGES.sendStreamClosed();
        }
    }
}

