/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.FragmentedTextFrameSender;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.xnio.Pool;
import org.xnio.Pooled;

final class TextWriter
extends Writer {
    private final FragmentedTextFrameSender sender;
    private final Pooled<ByteBuffer> pooled;
    private final CharBuffer buffer;
    private boolean closed;

    public TextWriter(FragmentedTextFrameSender sender, Pool<ByteBuffer> pool) {
        this.sender = sender;
        this.pooled = pool.allocate();
        this.buffer = ((ByteBuffer)this.pooled.getResource()).asCharBuffer();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int remaining = this.buffer.remaining();
        if (remaining >= len) {
            this.buffer.put(cbuf, off, len);
            this.send(false, false);
        } else {
            for (int left = len - remaining; left > 0; left -= remaining) {
                this.buffer.put(cbuf, off, remaining);
                this.send(false, false);
                remaining = this.buffer.remaining();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.send(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.closed = true;
                this.send(true, true);
            }
            finally {
                this.pooled.free();
            }
        }
    }

    private void send(boolean force, boolean last) throws IOException {
        if (force || !this.buffer.hasRemaining()) {
            this.buffer.flip();
            if (last) {
                this.sender.finalFragment();
            }
            this.sender.sendText((CharSequence)this.buffer);
            this.buffer.clear();
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw JsrWebSocketMessages.MESSAGES.sendWriterClosed();
        }
    }
}

