/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import org.xnio.Pool;
import org.xnio.channels.ConnectedStreamChannel;

public final class JsrHybi07Handshake
extends Hybi07Handshake {
    private final ConfiguredServerEndpoint config;

    public JsrHybi07Handshake(ConfiguredServerEndpoint config) {
        super(Collections.emptySet(), false);
        this.config = config;
    }

    protected void upgradeChannel(WebSocketHttpExchange exchange, byte[] data) {
        HandshakeUtil.prepareUpgrade(this.config.getEndpointConfiguration(), exchange);
        super.upgradeChannel(exchange, data);
    }

    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, ConnectedStreamChannel c, Pool<ByteBuffer> buffers) {
        WebSocketChannel channel = super.createChannel(exchange, c, buffers);
        HandshakeUtil.setConfig(channel, this.config);
        return channel;
    }

    public boolean matches(WebSocketHttpExchange exchange) {
        return super.matches(exchange) && HandshakeUtil.matches(this.config.getEndpointConfiguration(), exchange);
    }

    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        return this.config.getEndpointConfiguration().getServerEndpointConfigurator().getNegotiatedSubprotocol(this.config.getEndpointConfiguration().getSubprotocols(), Arrays.asList(requestedSubprotocolArray));
    }
}

