/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.FragmentedFrameHandler;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.jsr.AbstractFrameHandler;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UndertowSession;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;

class AsyncFrameHandler
extends AbstractFrameHandler<MessageHandler>
implements FragmentedFrameHandler {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private UTF8Output utf8Output;

    public AsyncFrameHandler(UndertowSession session, Endpoint endpoint) {
        super(session, endpoint);
    }

    public void onTextFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.TEXT);
        if (handler != null) {
            String text;
            boolean last = header.isLastFragement();
            if (this.utf8Output == null && last) {
                text = AsyncFrameHandler.toString(payload);
            } else {
                if (this.utf8Output == null) {
                    this.utf8Output = new UTF8Output(payload);
                } else {
                    this.utf8Output.write(payload);
                }
                text = this.utf8Output.extract();
                if (last) {
                    this.utf8Output = null;
                }
            }
            ((MessageHandler.Async)handler.getHandler()).onMessage((Object)text, last);
        }
    }

    @Override
    protected void verify(Class<?> type, MessageHandler handler) {
        if (handler instanceof MessageHandler.Async && type == PongMessage.class) {
            throw JsrWebSocketMessages.MESSAGES.pongMessageNotSupported();
        }
    }

    public void onBinaryFrame(WebSocketSession s, WebSocketFrameHeader header, ByteBuffer ... payload) {
        AbstractFrameHandler.HandlerWrapper handler = this.getHandler(AbstractFrameHandler.FrameType.BYTE);
        if (handler != null) {
            MessageHandler.Async mHandler = (MessageHandler.Async)handler.getHandler();
            if (handler.getMessageType() == ByteBuffer.class) {
                mHandler.onMessage((Object)AsyncFrameHandler.toBuffer(payload), header.isLastFragement());
            }
            if (handler.getMessageType() == byte[].class) {
                int size = AsyncFrameHandler.size(payload);
                if (size == 0) {
                    mHandler.onMessage((Object)EMPTY, header.isLastFragement());
                } else {
                    byte[] data = AsyncFrameHandler.toArray(payload);
                    mHandler.onMessage((Object)data, header.isLastFragement());
                }
            }
        }
    }

    protected static String toString(ByteBuffer ... payload) {
        ByteBuffer buffer = AsyncFrameHandler.toBuffer(payload);
        if (buffer.hasArray()) {
            return new String(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), UTF_8);
        }
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return new String(data, UTF_8);
    }

    static final class UTF8Output {
        private static final int UTF8_ACCEPT = 0;
        private static final byte[] TYPES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
        private static final byte[] STATES = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
        private int state = 0;
        private int codep;
        private final StringBuilder stringBuilder;

        UTF8Output(ByteBuffer ... payload) {
            this.stringBuilder = new StringBuilder(AbstractFrameHandler.size(payload));
            this.write(payload);
        }

        public void write(ByteBuffer ... bytes) {
            for (ByteBuffer buf : bytes) {
                while (buf.hasRemaining()) {
                    this.write(buf.get());
                }
            }
        }

        private void write(int b) {
            byte type = TYPES[b & 0xFF];
            this.codep = this.state != 0 ? b & 0x3F | this.codep << 6 : 255 >> type & b;
            this.state = STATES[this.state + type];
            if (this.state == 0) {
                this.stringBuilder.append((char)this.codep);
            }
        }

        public String extract() {
            String text = this.stringBuilder.toString();
            this.stringBuilder.delete(0, this.stringBuilder.length());
            return text;
        }
    }
}

