/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.jsr.annotated.BoundMethod;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.Session;

public class AnnotatedEndpoint
extends Endpoint {
    private final InstanceHandle<Object> instance;
    private final BoundMethod webSocketOpen;
    private final BoundMethod webSocketClose;
    private final BoundMethod webSocketError;
    private final BoundMethod textMessage;
    private final BoundMethod binaryByteArrayMessage;
    private final BoundMethod binaryByteBufferMessage;
    private final BoundMethod pongMessage;

    AnnotatedEndpoint(InstanceHandle<Object> instance, BoundMethod webSocketOpen, BoundMethod webSocketClose, BoundMethod webSocketError, BoundMethod textMessage, BoundMethod binaryByteArrayMessage, BoundMethod binaryByteBufferMessage, BoundMethod pongMessage) {
        this.instance = instance;
        this.webSocketOpen = webSocketOpen;
        this.webSocketClose = webSocketClose;
        this.webSocketError = webSocketError;
        this.textMessage = textMessage;
        this.binaryByteArrayMessage = binaryByteArrayMessage;
        this.binaryByteBufferMessage = binaryByteBufferMessage;
        this.pongMessage = pongMessage;
    }

    public void onOpen(Session session, EndpointConfiguration endpointConfiguration) {
        if (this.webSocketOpen != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(EndpointConfiguration.class, endpointConfiguration);
            params.put(Map.class, session.getPathParameters());
            this.webSocketOpen.invoke(this.instance.getInstance(), params);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (this.webSocketClose != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(Map.class, session.getPathParameters());
            this.webSocketClose.invoke(this.instance.getInstance(), params);
        }
    }

    public void onError(Session session, Throwable thr) {
        if (this.webSocketError != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(Throwable.class, thr);
            params.put(Map.class, session.getPathParameters());
            this.webSocketError.invoke(this.instance.getInstance(), params);
        }
    }
}

