/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.annotated.BoundMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfiguration;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;

public class AnnotatedEndpointFactory
implements InstanceFactory<Endpoint> {
    private final InstanceFactory<Object> underlyingFactory;
    private final Class<?> endpontClass;
    private final BoundMethod OnOpen;
    private final BoundMethod OnClose;
    private final BoundMethod OnError;
    private final BoundMethod textMessage;
    private final BoundMethod binaryByteArrayMessage;
    private final BoundMethod binaryByteBufferMessage;
    private final BoundMethod pongMessage;

    private AnnotatedEndpointFactory(Class<?> endpointClass, InstanceFactory<Object> underlyingFactory, EndpointConfiguration configuration, BoundMethod OnOpen, BoundMethod OnClose, BoundMethod OnError, BoundMethod textMessage, BoundMethod binaryByteArrayMessage, BoundMethod binaryByteBufferMessage, BoundMethod pongMessage) {
        this.underlyingFactory = underlyingFactory;
        this.endpontClass = endpointClass;
        this.OnOpen = OnOpen;
        this.OnClose = OnClose;
        this.OnError = OnError;
        this.textMessage = textMessage;
        this.binaryByteArrayMessage = binaryByteArrayMessage;
        this.binaryByteBufferMessage = binaryByteBufferMessage;
        this.pongMessage = pongMessage;
    }

    public static AnnotatedEndpointFactory create(Class<?> endpointClass, InstanceFactory<Object> underlyingInstance, EndpointConfiguration configuration) throws DeploymentException {
        HashSet<Class<OnError>> found = new HashSet<Class<OnError>>();
        BoundMethod OnOpen2 = null;
        BoundMethod OnClose2 = null;
        BoundMethod OnError2 = null;
        BoundMethod textMessage = null;
        BoundMethod binaryByteBufferMessage = null;
        BoundMethod binaryByteArrayMessage = null;
        BoundMethod pongMessage = null;
        Class<?> c = endpointClass;
        do {
            for (Method method : c.getDeclaredMethods()) {
                if (method.isAnnotationPresent(OnOpen.class)) {
                    if (found.contains(OnOpen.class)) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnOpen.class);
                    }
                    found.add(OnOpen.class);
                    OnOpen2 = new BoundMethod(method, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, EndpointConfiguration.class, true), new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method)));
                }
                if (method.isAnnotationPresent(OnClose.class)) {
                    if (found.contains(OnClose.class)) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnClose.class);
                    }
                    found.add(OnClose.class);
                    OnClose2 = new BoundMethod(method, new BoundSingleParameter(method, Session.class, true), new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method)));
                }
                if (method.isAnnotationPresent(OnError.class)) {
                    if (found.contains(OnError.class)) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnError.class);
                    }
                    found.add(OnError.class);
                    OnError2 = new BoundMethod(method, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Throwable.class, false), new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method)));
                }
                if (!method.isAnnotationPresent(OnMessage.class)) continue;
                boolean messageHandled = false;
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    Class<?> param = method.getParameterTypes()[i];
                    if (param.equals(byte[].class)) {
                        if (binaryByteArrayMessage != null || binaryByteBufferMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryByteArrayMessage = new BoundMethod(method, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, false), new BoundSingleParameter(method, byte[].class, false), new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method)));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(ByteBuffer.class)) {
                        if (binaryByteArrayMessage != null || binaryByteBufferMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        binaryByteBufferMessage = new BoundMethod(method, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, false), new BoundSingleParameter(method, ByteBuffer.class, false), new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method)));
                        messageHandled = true;
                        break;
                    }
                    if (param.equals(String.class) && AnnotatedEndpointFactory.getPathParam(method, i) == null) {
                        if (textMessage != null) {
                            throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                        }
                        textMessage = new BoundMethod(method, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, false), new BoundSingleParameter(method, String.class, false), new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method)));
                        messageHandled = true;
                        break;
                    }
                    if (!param.equals(PongMessage.class)) continue;
                    if (pongMessage != null) {
                        throw JsrWebSocketMessages.MESSAGES.moreThanOneAnnotation(OnMessage.class);
                    }
                    pongMessage = new BoundMethod(method, new BoundSingleParameter(method, Session.class, true), new BoundSingleParameter(method, Boolean.TYPE, false), new BoundSingleParameter(method, PongMessage.class, false), new BoundPathParameters(AnnotatedEndpointFactory.pathParams(method)));
                    messageHandled = true;
                    break;
                }
                if (messageHandled) continue;
                throw new DeploymentException("TODO: decoders");
            }
        } while ((c = c.getSuperclass()) != Object.class && c != null);
        return new AnnotatedEndpointFactory(endpointClass, underlyingInstance, configuration, OnOpen2, OnClose2, OnError2, textMessage, binaryByteArrayMessage, binaryByteBufferMessage, pongMessage);
    }

    private static Map<String, Integer> pathParams(Method method) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            PathParam param = AnnotatedEndpointFactory.getPathParam(method, i);
            if (param == null) continue;
            params.put(param.value(), i);
        }
        return params;
    }

    private static PathParam getPathParam(Method method, int parameter) {
        for (Annotation annotation : method.getParameterAnnotations()[parameter]) {
            if (!annotation.annotationType().equals(PathParam.class)) continue;
            return (PathParam)annotation;
        }
        return null;
    }

    public InstanceHandle<Endpoint> createInstance() throws InstantiationException {
        final InstanceHandle instance = this.underlyingFactory.createInstance();
        final AnnotatedEndpoint endpoint = new AnnotatedEndpoint((InstanceHandle<Object>)instance, this.OnOpen, this.OnClose, this.OnError, this.textMessage, this.binaryByteArrayMessage, this.binaryByteBufferMessage, this.pongMessage);
        return new InstanceHandle<Endpoint>(){

            public Endpoint getInstance() {
                return endpoint;
            }

            public void release() {
                instance.release();
            }
        };
    }

    private static class BoundPathParameters
    implements BoundParameter {
        private final Map<String, Integer> postions;

        public BoundPathParameters(Map<String, Integer> postions) {
            this.postions = postions;
        }

        @Override
        public Set<Integer> positions() {
            return new HashSet<Integer>(this.postions.values());
        }

        @Override
        public void populate(Object[] params, Map<Class<?>, Object> value) {
            Map data = (Map)value.get(Map.class);
            for (Map.Entry entry : data.entrySet()) {
                params[this.postions.get(entry.getKey()).intValue()] = entry.getValue();
            }
        }
    }

    private static class BoundSingleParameter
    implements BoundParameter {
        private final int position;
        private final boolean optional;
        private final Class<?> type;

        public BoundSingleParameter(Method method, Class<?> type, boolean optional) {
            this.optional = optional;
            this.type = type;
            int pos = -1;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                if (!method.getParameterTypes()[i].equals(Session.class)) continue;
                if (pos != -1) {
                    throw JsrWebSocketMessages.MESSAGES.moreThanOneParameterOfType(type, method);
                }
                pos = i;
            }
            if (pos != -1) {
                this.position = pos;
            } else if (optional) {
                this.position = -1;
            } else {
                throw JsrWebSocketMessages.MESSAGES.parameterNotFound(type, method);
            }
        }

        @Override
        public Set<Integer> positions() {
            if (this.position == -1) {
                return Collections.emptySet();
            }
            return Collections.singleton(this.position);
        }

        @Override
        public void populate(Object[] params, Map<Class<?>, Object> value) {
            params[this.position] = value.get(this.type);
        }
    }

    public static interface BoundParameter {
        public Set<Integer> positions();

        public void populate(Object[] var1, Map<Class<?>, Object> var2);
    }
}

