/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.websocket.DeploymentException;

final class BoundMethod {
    private final Method method;
    private final List<AnnotatedEndpointFactory.BoundParameter> parameters = new ArrayList<AnnotatedEndpointFactory.BoundParameter>();

    public BoundMethod(Method method, AnnotatedEndpointFactory.BoundParameter ... params) throws DeploymentException {
        this.method = method;
        HashSet<Integer> allParams = new HashSet<Integer>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            allParams.add(i);
        }
        for (AnnotatedEndpointFactory.BoundParameter param : params) {
            this.parameters.add(param);
            allParams.removeAll(param.positions());
        }
        if (!allParams.isEmpty()) {
            throw JsrWebSocketMessages.MESSAGES.invalidParamers(method, allParams);
        }
    }

    public void invoke(Object instance, Map<Class<?>, Object> values) {
        Object[] params = new Object[this.method.getParameterTypes().length];
        for (AnnotatedEndpointFactory.BoundParameter param : this.parameters) {
            param.populate(params, values);
        }
        try {
            this.method.invoke(instance, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

