/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.websockets.jsr.util.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.EndpointConfiguration;

public class DecoderUtils {
    public static List<Decoder> getDecodersForType(Class<?> type, EndpointConfiguration endpointConfiguration) {
        ArrayList<Decoder> decoders = new ArrayList<Decoder>();
        for (Decoder decoder : endpointConfiguration.getDecoders()) {
            Class<?> clazz = ClassUtils.getDecoderType(decoder.getClass());
            if (!type.isAssignableFrom(clazz)) continue;
            decoders.add(decoder);
        }
        if (!decoders.isEmpty()) {
            return decoders;
        }
        return null;
    }

    private DecoderUtils() {
    }
}

