/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.jsr.AbstractFrameHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="UT")
public interface JsrWebSocketMessages {
    public static final JsrWebSocketMessages MESSAGES = (JsrWebSocketMessages)Messages.getBundle(JsrWebSocketMessages.class);

    @Message(id=3001, value="PongMessage not supported with MessageHandler.Async")
    public IllegalStateException pongMessageNotSupported();

    @Message(id=3002, value="SendStream is closed")
    public IOException sendStreamClosed();

    @Message(id=3003, value="SendWriter is closed")
    public IOException sendWriterClosed();

    @Message(id=3004, value="Client not supported")
    public DeploymentException clientNotSupported();

    @Message(id=3005, value="MessageHandler for type %s already registered")
    public IllegalStateException handlerAlreadyRegistered(AbstractFrameHandler.FrameType var1);

    @Message(id=3006, value="Unable to detect FrameType for clazz %s")
    public IllegalStateException unsupportedFrameType(Class<?> var1);

    @Message(id=3007, value="Unable to detect MessageHandler type for %s")
    public IllegalStateException unknownHandlerType(Class<?> var1);

    @Message(id=3008, value="Unable to detect Encoder type for %s")
    public IllegalStateException unknownEncoderType(Class<?> var1);

    @Message(id=3009, value="More than one %s parameter for %s")
    public IllegalArgumentException moreThanOneParameterOfType(Class<?> var1, Method var2);

    @Message(id=3010, value="No parameter of type %s found in method %s")
    public IllegalArgumentException parameterNotFound(Class<?> var1, Method var2);

    @Message(id=3011, value="More than one method is annotated with %s")
    public DeploymentException moreThanOneAnnotation(Class<?> var1);

    @Message(id=3012, value="Method %s has invalid parameters %s")
    public DeploymentException invalidParamers(Method var1, Set<Integer> var2);

    @Message(id=3014, value="Could not determine decoder type for %s")
    public IllegalArgumentException couldNotDetermineDecoderTypeFor(Class<?> var1);

    @Message(id=3015, value="No decoder accepted message %s")
    public String noDecoderAcceptedMessage(List<? extends Decoder> var1);

    @Message(id=3016, value="Cannot send in middle of fragmeneted message")
    public IllegalStateException cannotSendInMiddleOfFragmentedMessage();
}

