/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.handshake;

import io.undertow.util.AttachmentKey;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.handshake.ExchangeHandshakeRequest;
import io.undertow.websockets.jsr.handshake.ExchangeHandshakeResponse;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfiguration;
import javax.websocket.server.ServerEndpointConfigurator;

public final class HandshakeUtil {
    private static final String CONFIG_KEY = "ServerEndpointConfiguration";
    public static final AttachmentKey<Map<String, String>> PATH_PARAMS = AttachmentKey.create(Map.class);

    private HandshakeUtil() {
    }

    public static boolean matches(ServerEndpointConfiguration config, WebSocketHttpExchange exchange) {
        HashMap pathParams = new HashMap();
        exchange.putAttachment(PATH_PARAMS, pathParams);
        ServerEndpointConfigurator c = config.getServerEndpointConfigurator();
        URI requestUri = URI.create(exchange.getRequestURI());
        return c.checkOrigin(exchange.getRequestHeader("Origin")) && c.matchesURI(config.getPath(), requestUri, pathParams);
    }

    public static void prepareUpgrade(ServerEndpointConfiguration config, WebSocketHttpExchange exchange) {
        ExchangeHandshakeRequest request = new ExchangeHandshakeRequest(exchange);
        ExchangeHandshakeResponse response = new ExchangeHandshakeResponse(exchange);
        ServerEndpointConfigurator c = config.getServerEndpointConfigurator();
        c.modifyHandshake(config, (HandshakeRequest)request, (HandshakeResponse)response);
        response.update();
    }

    public static void setConfig(WebSocketChannel channel, ConfiguredServerEndpoint config) {
        channel.setAttribute(CONFIG_KEY, (Object)config);
    }

    public static ConfiguredServerEndpoint getConfig(WebSocketChannel channel) {
        return (ConfiguredServerEndpoint)channel.getAttribute(CONFIG_KEY);
    }
}

