/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.api.FragmentedBinaryFrameSender;
import io.undertow.websockets.api.FragmentedTextFrameSender;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.impl.WebSocketChannelSession;
import io.undertow.websockets.jsr.BinaryOutputStream;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.SendHandlerAdapter;
import io.undertow.websockets.jsr.SendResultFuture;
import io.undertow.websockets.jsr.TextWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.xnio.Pool;

final class WebSocketSessionRemoteEndpoint
implements RemoteEndpoint {
    private final WebSocketChannelSession session;
    private final EndpointConfig config;
    private final RemoteEndpoint.Async async = new AsyncWebSocketSessionRemoteEndpoint();
    private final RemoteEndpoint.Basic basic = new BasicWebSocketSessionRemoteEndpoint();

    public WebSocketSessionRemoteEndpoint(WebSocketChannelSession session, EndpointConfig config) {
        this.session = session;
        this.config = config;
    }

    public RemoteEndpoint.Async getAsync() {
        return this.async;
    }

    public RemoteEndpoint.Basic getBasic() {
        return this.basic;
    }

    public void flushBatch() {
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        this.session.sendPing(applicationData);
    }

    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        this.session.sendPong(applicationData);
    }

    class BasicWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Basic {
        private FragmentedBinaryFrameSender binaryFrameSender;
        private FragmentedTextFrameSender textFrameSender;

        BasicWebSocketSessionRemoteEndpoint() {
        }

        public void assertNotInFragment() {
            if (this.textFrameSender != null || this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
        }

        public void sendText(String text) throws IOException {
            this.assertNotInFragment();
            WebSocketSessionRemoteEndpoint.this.session.sendText((CharSequence)text);
        }

        public void sendBinary(ByteBuffer data) throws IOException {
            this.assertNotInFragment();
            WebSocketSessionRemoteEndpoint.this.session.sendBinary(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendText(String partialMessage, boolean isLast) throws IOException {
            if (this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.textFrameSender == null) {
                this.textFrameSender = WebSocketSessionRemoteEndpoint.this.session.sendFragmentedText();
            }
            if (isLast) {
                this.textFrameSender.finalFragment();
            }
            try {
                this.textFrameSender.sendText((CharSequence)partialMessage);
            }
            finally {
                if (isLast) {
                    this.textFrameSender = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            if (this.textFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.binaryFrameSender == null) {
                this.binaryFrameSender = WebSocketSessionRemoteEndpoint.this.session.sendFragmentedBinary();
            }
            if (isLast) {
                this.binaryFrameSender.finalFragment();
            }
            try {
                this.binaryFrameSender.sendBinary(partialByte);
            }
            finally {
                if (isLast) {
                    this.binaryFrameSender = null;
                }
            }
        }

        public OutputStream getSendStream() throws IOException {
            this.assertNotInFragment();
            return new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.session.sendFragmentedBinary(), (Pool<ByteBuffer>)WebSocketSessionRemoteEndpoint.this.session.getBufferPool());
        }

        public Writer getSendWriter() throws IOException {
            this.assertNotInFragment();
            return new TextWriter(WebSocketSessionRemoteEndpoint.this.session.sendFragmentedText(), (Pool<ByteBuffer>)WebSocketSessionRemoteEndpoint.this.session.getBufferPool());
        }

        public void sendObject(Object data) throws IOException, EncodeException {
            this.sendObjectImpl(data);
        }

        private void sendObjectImpl(Object o) throws IOException {
            try {
                throw new EncodeException(o, "No suitable encoder found");
            }
            catch (EncodeException e) {
                throw new RuntimeException(e);
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSocketSessionRemoteEndpoint.this.session.sendPing(applicationData);
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSocketSessionRemoteEndpoint.this.session.sendPong(applicationData);
        }
    }

    class AsyncWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Async {
        AsyncWebSocketSessionRemoteEndpoint() {
        }

        public long getSendTimeout() {
            return WebSocketSessionRemoteEndpoint.this.session.getAsyncSendTimeout();
        }

        public void setSendTimeout(long timeoutmillis) {
            WebSocketSessionRemoteEndpoint.this.session.setAsyncSendTimeout((int)timeoutmillis);
        }

        public void sendText(String text, SendHandler handler) {
            WebSocketSessionRemoteEndpoint.this.session.sendText((CharSequence)text, (SendCallback)new SendHandlerAdapter(handler));
        }

        public Future<Void> sendText(String text) {
            SendResultFuture future = new SendResultFuture();
            WebSocketSessionRemoteEndpoint.this.session.sendText((CharSequence)text, (SendCallback)future);
            return future;
        }

        public Future<Void> sendBinary(ByteBuffer data) {
            SendResultFuture future = new SendResultFuture();
            WebSocketSessionRemoteEndpoint.this.session.sendBinary(data, (SendCallback)future);
            return future;
        }

        public void sendBinary(ByteBuffer data, SendHandler completion) {
            WebSocketSessionRemoteEndpoint.this.session.sendBinary(data, (SendCallback)new SendHandlerAdapter(completion));
        }

        public Future<Void> sendObject(Object o) {
            SendResultFuture future = new SendResultFuture();
            this.sendObjectImpl(o, future);
            return future;
        }

        public void sendObject(Object data, SendHandler handler) {
            this.sendObjectImpl(data, new SendHandlerAdapter(handler));
        }

        private void sendObjectImpl(Object o, SendCallback callback) {
            try {
                throw new EncodeException(o, "No suitable encoder found");
            }
            catch (EncodeException e) {
                throw new RuntimeException(e);
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSocketSessionRemoteEndpoint.this.session.sendPing(applicationData);
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSocketSessionRemoteEndpoint.this.session.sendPong(applicationData);
        }
    }
}

