/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.session.Session;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.util.PathTemplateMatcher;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.websocket.CloseReason;
import javax.websocket.server.ServerContainer;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;

public class JsrWebSocketFilter
implements Filter {
    private WebSocketConnectionCallback callback;
    private PathTemplateMatcher<ServerWebSocketContainer.WebSocketHandshakeHolder> pathTemplateMatcher;
    private Set<WebSocketChannel> peerConnections;
    private ServerWebSocketContainer container;
    private static final String SESSION_ATTRIBUTE = "io.undertow.websocket.current-connections";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.peerConnections = Collections.newSetFromMap(new ConcurrentHashMap());
        this.container = (ServerWebSocketContainer)filterConfig.getServletContext().getAttribute(ServerContainer.class.getName());
        this.container.deploymentComplete();
        this.pathTemplateMatcher = new PathTemplateMatcher();
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)filterConfig.getServletContext().getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        for (ConfiguredServerEndpoint endpoint : this.container.getConfiguredServerEndpoints()) {
            if (info == null || info.getExtensions().isEmpty()) {
                this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)ServerWebSocketContainer.handshakes(endpoint));
                continue;
            }
            this.pathTemplateMatcher.add(endpoint.getPathTemplate(), (Object)ServerWebSocketContainer.handshakes(endpoint, info.getExtensions()));
        }
        this.callback = new EndpointSessionHandler(this.container);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getHeader("Upgrade") != null) {
            PathTemplateMatcher.PathMatchResult matchResult;
            final ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(req, resp, this.peerConnections);
            String path = req.getPathInfo() == null ? req.getServletPath() : req.getServletPath() + req.getPathInfo();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((matchResult = this.pathTemplateMatcher.match(path)) != null) {
                Handshake handshaker = null;
                for (Handshake method : ((ServerWebSocketContainer.WebSocketHandshakeHolder)matchResult.getValue()).handshakes) {
                    if (!method.matches((WebSocketHttpExchange)facade)) continue;
                    handshaker = method;
                    break;
                }
                if (handshaker != null) {
                    if (this.container.isClosed()) {
                        resp.sendError(503);
                        return;
                    }
                    facade.putAttachment(HandshakeUtil.PATH_PARAMS, (Object)matchResult.getParameters());
                    facade.putAttachment(HandshakeUtil.PRINCIPAL, (Object)req.getUserPrincipal());
                    final Handshake selected = handshaker;
                    final HttpSessionImpl session = (HttpSessionImpl)req.getSession(false);
                    facade.upgradeChannel(new HttpUpgradeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                            WebSocketChannel channel = selected.createChannel((WebSocketHttpExchange)facade, streamConnection, facade.getBufferPool());
                            JsrWebSocketFilter.this.peerConnections.add(channel);
                            if (session != null) {
                                ArrayList<WebSocketChannel> connections;
                                final Session underlying = System.getSecurityManager() == null ? session.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)session));
                                Session session2 = underlying;
                                synchronized (session2) {
                                    connections = (ArrayList<WebSocketChannel>)underlying.getAttribute(JsrWebSocketFilter.SESSION_ATTRIBUTE);
                                    if (connections == null) {
                                        connections = new ArrayList<WebSocketChannel>();
                                        underlying.setAttribute(JsrWebSocketFilter.SESSION_ATTRIBUTE, connections);
                                    }
                                    connections.add(channel);
                                }
                                final ArrayList<WebSocketChannel> finalConnections = connections;
                                channel.addCloseTask((ChannelListener)new ChannelListener<WebSocketChannel>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void handleEvent(WebSocketChannel channel) {
                                        Session session = underlying;
                                        synchronized (session) {
                                            finalConnections.remove(channel);
                                        }
                                    }
                                });
                            }
                            JsrWebSocketFilter.this.callback.onConnect((WebSocketHttpExchange)facade, channel);
                        }
                    });
                    handshaker.handshake((WebSocketHttpExchange)facade);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static class LogoutListener
    implements HttpSessionListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionDestroyed(HttpSessionEvent se) {
            HttpSessionImpl session = (HttpSessionImpl)se.getSession();
            Session underlying = System.getSecurityManager() == null ? session.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)session));
            List connections = (List)underlying.getAttribute(JsrWebSocketFilter.SESSION_ATTRIBUTE);
            if (connections != null) {
                Session session2 = underlying;
                synchronized (session2) {
                    for (WebSocketChannel c : connections) {
                        WebSockets.sendClose((int)CloseReason.CloseCodes.VIOLATED_POLICY.getCode(), (String)"", (WebSocketChannel)c, null);
                    }
                }
            }
        }

        public void sessionCreated(HttpSessionEvent se) {
        }
    }
}

