/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.match.model;

import io.vavr.match.model.ClassModel;
import io.vavr.match.model.ParameterModel;
import io.vavr.match.model.TypeParameterModel;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;

public class MethodModel {
    private final Elements elementUtils;
    private final ExecutableElement executableElement;

    public MethodModel(Elements elementUtils, ExecutableElement executableElement) {
        this.elementUtils = elementUtils;
        this.executableElement = executableElement;
    }

    public ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public String getName() {
        return this.executableElement.getSimpleName().toString();
    }

    public ParameterModel getParameter(int index) {
        List<? extends VariableElement> parameters = this.executableElement.getParameters();
        if (index < 0 || index > parameters.size()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return new ParameterModel(this.elementUtils, parameters.get(index));
    }

    public ClassModel getReturnType() {
        return new ClassModel(this.elementUtils, (DeclaredType)this.executableElement.getReturnType());
    }

    public List<TypeParameterModel> getTypeParameters() {
        return this.executableElement.getTypeParameters().stream().map(typeParam -> new TypeParameterModel(this.elementUtils, typeParam.asType())).collect(Collectors.toList());
    }

    public <A extends Annotation> boolean isAnnotatedWith(Class<A> annotationType) {
        return this.executableElement.getAnnotationsByType(annotationType).length > 0;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof MethodModel && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.executableElement.toString();
    }
}

