/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp;

import io.vertx.amqp.AmqpReceiverOptionsConverter;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@DataObject(generateConverter=true)
public class AmqpReceiverOptions {
    private String linkName;
    private boolean dynamic;
    private String qos;
    private List<String> capabilities = new ArrayList<String>();
    private boolean durable;
    private int maxBufferedMessages;
    private boolean autoAcknowledgement = true;

    public AmqpReceiverOptions() {
    }

    public AmqpReceiverOptions(AmqpReceiverOptions other) {
        this();
        this.setDynamic(other.isDynamic());
        this.setLinkName(other.getLinkName());
        this.setCapabilities(other.getCapabilities());
        this.setDurable(other.isDurable());
        this.setMaxBufferedMessages(other.maxBufferedMessages);
    }

    public AmqpReceiverOptions(JsonObject json) {
        AmqpReceiverOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AmqpReceiverOptionsConverter.toJson(this, json);
        return json;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public AmqpReceiverOptions setLinkName(String linkName) {
        this.linkName = linkName;
        return this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public AmqpReceiverOptions setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public String getQos() {
        return this.qos;
    }

    public AmqpReceiverOptions setQos(String qos) {
        this.qos = qos;
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            return new ArrayList<String>();
        }
        return this.capabilities;
    }

    public AmqpReceiverOptions setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public AmqpReceiverOptions addCapability(String capability) {
        Objects.requireNonNull(capability, "The capability must not be null");
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        this.capabilities.add(capability);
        return this;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public AmqpReceiverOptions setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public int getMaxBufferedMessages() {
        return this.maxBufferedMessages;
    }

    public AmqpReceiverOptions setMaxBufferedMessages(int maxBufferSize) {
        this.maxBufferedMessages = maxBufferSize;
        return this;
    }

    public boolean isAutoAcknowledgement() {
        return this.autoAcknowledgement;
    }

    public AmqpReceiverOptions setAutoAcknowledgement(boolean auto) {
        this.autoAcknowledgement = auto;
        return this;
    }
}

