/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.authorization.impl.VariableAwareExpression;
import java.util.Objects;

public class RoleBasedAuthorizationImpl
implements RoleBasedAuthorization {
    private String role;
    private VariableAwareExpression resource;

    public RoleBasedAuthorizationImpl(String role) {
        this.role = Objects.requireNonNull(role);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RoleBasedAuthorizationImpl)) {
            return false;
        }
        RoleBasedAuthorizationImpl other = (RoleBasedAuthorizationImpl)obj;
        return Objects.equals(this.resource, other.resource) && Objects.equals(this.role, other.role);
    }

    @Override
    public String getRole() {
        return this.role;
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.role);
    }

    @Override
    public boolean match(AuthorizationContext context) {
        Objects.requireNonNull(context);
        User user = context.user();
        if (user != null) {
            RoleBasedAuthorization resolvedAuthorization = this.getResolvedAuthorization(context);
            for (String providerId : user.authorizations().getProviderIds()) {
                for (Authorization authorization : user.authorizations().get(providerId)) {
                    if (!authorization.verify(resolvedAuthorization)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private RoleBasedAuthorization getResolvedAuthorization(AuthorizationContext context) {
        if (this.resource == null || !this.resource.hasVariable()) {
            return this;
        }
        return RoleBasedAuthorization.create(this.role).setResource(this.resource.resolve(context));
    }

    @Override
    public boolean verify(Authorization otherAuthorization) {
        RoleBasedAuthorization otherRoleBasedAuthorization;
        Objects.requireNonNull(otherAuthorization);
        if (otherAuthorization instanceof RoleBasedAuthorization && this.role.equals((otherRoleBasedAuthorization = (RoleBasedAuthorization)otherAuthorization).getRole())) {
            if (this.getResource() == null) {
                return otherRoleBasedAuthorization.getResource() == null;
            }
            return this.getResource().equals(otherRoleBasedAuthorization.getResource());
        }
        return false;
    }

    @Override
    public String getResource() {
        return this.resource != null ? this.resource.getValue() : null;
    }

    @Override
    public RoleBasedAuthorization setResource(String resource) {
        Objects.requireNonNull(resource);
        this.resource = new VariableAwareExpression(resource);
        return this;
    }
}

