/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import io.vertx.codegen.Helper;
import io.vertx.codegen.ModuleInfo;
import io.vertx.codegen.TypeParamInfo;
import io.vertx.codegen.format.CamelCase;
import io.vertx.codegen.format.Case;
import io.vertx.codegen.type.ClassKind;
import io.vertx.codegen.type.DataObjectInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.TypeNameTranslator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ClassTypeInfo
extends TypeInfo {
    static final HashMap<String, ClassTypeInfo> PRIMITIVES;
    final ClassKind kind;
    final String name;
    final String simpleName;
    final String packageName;
    final ModuleInfo module;
    final boolean nullable;
    final List<TypeParamInfo.Class> params;
    final DataObjectInfo dataObject;

    public ClassTypeInfo(ClassKind kind, String name, ModuleInfo module, boolean nullable, List<TypeParamInfo.Class> params, DataObjectInfo dataObject) {
        this.kind = kind;
        this.name = name;
        this.simpleName = Helper.getSimpleName(name);
        this.packageName = Helper.getPackageName(name);
        this.module = module;
        this.nullable = nullable;
        this.params = params;
        this.dataObject = dataObject;
    }

    public List<TypeParamInfo.Class> getParams() {
        return this.params;
    }

    public String getModuleName() {
        return this.module != null ? this.module.getName() : null;
    }

    public ModuleInfo getModule() {
        return this.module;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public ClassKind getKind() {
        return this.kind;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getSimpleName(Case _case) {
        return _case.format(CamelCase.INSTANCE.parse(this.simpleName));
    }

    @Override
    public ClassTypeInfo getRaw() {
        return this;
    }

    @Override
    public void collectImports(Collection<ClassTypeInfo> imports) {
        imports.add(this);
    }

    @Override
    public DataObjectInfo getDataObject() {
        return this.dataObject;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ClassTypeInfo) {
            return this.name.equals(((ClassTypeInfo)obj).name);
        }
        return false;
    }

    @Override
    public String format(boolean qualified) {
        return qualified ? this.name : this.simpleName;
    }

    @Override
    public String translateName(String id) {
        return this.module == null ? this.name : this.module.translateQualifiedName(this.name, id);
    }

    public String translatePackageName(String id) {
        return this.module == null ? this.packageName : this.module.translateQualifiedName(this.packageName, id);
    }

    @Override
    public String translateName(TypeNameTranslator translator) {
        return this.module == null ? this.name : translator.translate(this.module, this.name);
    }

    public String translatePackageName(TypeNameTranslator translator) {
        return this.module == null ? this.packageName : translator.translate(this.module, this.packageName);
    }

    static {
        Class[] boxes;
        PRIMITIVES = new HashMap();
        for (Class boxe : boxes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class}) {
            String name = boxe.getName();
            PRIMITIVES.put(name, new ClassTypeInfo(ClassKind.BOXED_PRIMITIVE, name, null, false, Collections.emptyList(), null));
        }
    }
}

